/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.Serializable;
import org.snmp4j.CertifiedIdentity;
import org.snmp4j.SecureTarget;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TlsAddress;

public class CertifiedTarget<A extends Address>
extends SecureTarget<A>
implements CertifiedIdentity,
Serializable {
    private static final long serialVersionUID = 1L;
    private OctetString serverFingerprint;
    private OctetString clientFingerprint;

    public CertifiedTarget(OctetString identity) {
        super(new TlsAddress(), identity);
        this.setSecurityModel(4);
    }

    public CertifiedTarget(A address, OctetString identity, OctetString serverFingerprint, OctetString clientFingerprint) {
        super(address, identity);
        this.serverFingerprint = serverFingerprint;
        this.clientFingerprint = clientFingerprint;
        this.setSecurityModel(4);
    }

    @Override
    public OctetString getServerFingerprint() {
        return this.serverFingerprint;
    }

    @Override
    public OctetString getClientFingerprint() {
        return this.clientFingerprint;
    }

    @Override
    public OctetString getIdentity() {
        return super.getSecurityName();
    }

    @Override
    public String toString() {
        return "CertifiedTarget[" + this.toStringAbstractTarget() + ", serverFingerprint=" + this.serverFingerprint + ", clientFingerprint=" + this.clientFingerprint + "]";
    }

    @Override
    public Target<A> duplicate() {
        CertifiedTarget copy = new CertifiedTarget(this.getAddress(), this.getIdentity(), this.serverFingerprint, this.clientFingerprint);
        copy.setRetries(this.getRetries());
        copy.setTimeout(this.getTimeout());
        copy.setMaxSizeRequestPDU(this.getMaxSizeRequestPDU());
        copy.setPreferredTransports(this.getPreferredTransports());
        copy.setVersion(this.getVersion());
        copy.setSecurityLevel(this.getSecurityLevel());
        copy.setSecurityModel(this.getSecurityModel());
        return copy;
    }
}

