/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.config.UniSmsProperties;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.util.CryptoUtils;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(UniSmsClientImpl.class);
    private static final String API_URL = "https://uni.apistd.com";
    private static final String ACTION = "sms.message.send";
    private static final String SUCCESS_CODE = "0";
    private static final String HMAC_ALGORITHM = "hmac-sha256";
    private final UniSmsProperties config;

    public UniSmsClientImpl(UniSmsProperties config) {
        this.config = config;
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("to", receiver.getPhone());
            params.put("signature", this.config.getSignature());
            params.put("templateId", this.config.getTemplateId());
            HashMap<String, String> templateData = new HashMap<String, String>();
            String instance = alert.getCommonLabels().getOrDefault("instance", alert.getGroupKey());
            String priority = alert.getCommonLabels().getOrDefault("priority", "unknown");
            String content = (String)alert.getCommonAnnotations().get("summary");
            String string = content = content == null ? (String)alert.getCommonAnnotations().get("description") : content;
            if (content == null) {
                content = alert.getCommonAnnotations().values().stream().findFirst().orElse(null);
            }
            templateData.put("instance", instance);
            templateData.put("priority", priority);
            templateData.put("content", content);
            params.put("templateData", templateData);
            String url = "hmac".equalsIgnoreCase(this.config.getAuthMode()) ? this.buildHmacUrl() : this.buildSimpleUrl();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");
            String payload = JsonUtil.toJson(params);
            httpPost.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
            log.info("Sending SMS request to UniSMS, payload: {}, url: {}", (Object)payload, (Object)url);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                this.handleResponse(response, receiver.getPhone());
            }
        }
        catch (Exception e) {
            log.error("Failed to send SMS via UniSMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    private String buildSimpleUrl() {
        return String.format("%s/?action=%s&accessKeyId=%s", API_URL, ACTION, this.config.getAccessKeyId());
    }

    private String buildHmacUrl() {
        long timestamp = System.currentTimeMillis();
        String nonce = this.generateNonce();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("accessKeyId", this.config.getAccessKeyId());
        params.put("action", ACTION);
        params.put("algorithm", HMAC_ALGORITHM);
        params.put("nonce", nonce);
        params.put("timestamp", String.valueOf(timestamp));
        String signText = params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        String signature = CryptoUtils.hmacSha256Base64(this.config.getAccessKeySecret(), signText);
        return String.format("%s/?action=%s&accessKeyId=%s&algorithm=%s&timestamp=%d&nonce=%s&signature=%s", API_URL, ACTION, this.config.getAccessKeyId(), HMAC_ALGORITHM, timestamp, nonce, signature);
    }

    private String generateNonce() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    private void handleResponse(CloseableHttpResponse response, String phone) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        log.info("UniSMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
        if (statusCode != 200) {
            throw new SendMessageException("HTTP request failed with status code: " + statusCode + ", response: " + responseBody);
        }
        JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
        String code = jsonResponse.get("code").asText();
        if (!SUCCESS_CODE.equals(code)) {
            String message = jsonResponse.get("message").asText();
            throw new SendMessageException(code + ":" + message);
        }
        log.info("Successfully sent SMS to phone: {}", (Object)phone);
    }

    @Override
    public String getType() {
        return "unisms";
    }

    @Override
    public boolean checkConfig() {
        if (this.config == null || this.config.getAccessKeyId() == null || this.config.getAccessKeyId().isBlank() || this.config.getSignature() == null || this.config.getSignature().isBlank() || this.config.getTemplateId() == null || this.config.getTemplateId().isBlank()) {
            return false;
        }
        return !"hmac".equalsIgnoreCase(this.config.getAuthMode()) || this.config.getAccessKeySecret() != null && !this.config.getAccessKeySecret().isBlank();
    }
}

