/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.AbstractKafkaConsumerRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaUtil;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaProcessRequest
extends AbstractKafkaConsumerRequest {
    private final ConsumerRecord<?, ?> record;

    public static KafkaProcessRequest create(ConsumerRecord<?, ?> record, Consumer<?, ?> consumer) {
        return KafkaProcessRequest.create(record, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer));
    }

    public static KafkaProcessRequest create(KafkaConsumerContext consumerContext, ConsumerRecord<?, ?> record) {
        String consumerGroup = consumerContext != null ? consumerContext.getConsumerGroup() : null;
        String clientId = consumerContext != null ? consumerContext.getClientId() : null;
        return KafkaProcessRequest.create(record, consumerGroup, clientId);
    }

    public static KafkaProcessRequest create(ConsumerRecord<?, ?> record, String consumerGroup, String clientId) {
        return new KafkaProcessRequest(record, consumerGroup, clientId);
    }

    public KafkaProcessRequest(ConsumerRecord<?, ?> record, String consumerGroup, String clientId) {
        super(consumerGroup, clientId);
        this.record = record;
    }

    public ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }
}

