/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="memory", matchIfMissing=true)
@Primary
public class InMemoryCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(InMemoryCommonDataQueue.class);
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToStorageQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<CollectRep.MetricsData> serviceDiscoveryDataQueue = new LinkedBlockingQueue();

    public Map<String, Integer> getQueueSizeMetricsInfo() {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>(8);
        metrics.put("metricsDataToAlertQueue", this.metricsDataToAlertQueue.size());
        metrics.put("metricsDataToStorageQueue", this.metricsDataToStorageQueue.size());
        return metrics;
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        return this.serviceDiscoveryDataQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.metricsDataToAlertQueue.take();
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        return this.metricsDataToStorageQueue.take();
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        this.metricsDataToAlertQueue.offer(metricsData);
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        this.metricsDataToStorageQueue.offer(metricsData);
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        this.serviceDiscoveryDataQueue.offer(metricsData);
    }

    public void destroy() {
        this.metricsDataToAlertQueue.clear();
        this.metricsDataToStorageQueue.clear();
        this.serviceDiscoveryDataQueue.clear();
    }
}

