/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.greptime.PojoObjectMapper;
import io.greptime.common.SPI;
import io.greptime.common.util.Ensures;
import io.greptime.errors.PojoException;
import io.greptime.models.Column;
import io.greptime.models.DataType;
import io.greptime.models.Metric;
import io.greptime.models.SemanticType;
import io.greptime.models.Table;
import io.greptime.models.TableSchema;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SPI(priority=9)
public class CachedPojoObjectMapper
implements PojoObjectMapper {
    private final LoadingCache<Class<?>, Map<String, Field>> classFieldCache;

    public CachedPojoObjectMapper() {
        this(1024);
    }

    public CachedPojoObjectMapper(int maxCachedPOJOs) {
        this.classFieldCache = CacheBuilder.newBuilder().maximumSize((long)maxCachedPOJOs).build(new CacheLoader<Class<?>, Map<String, Field>>(){

            public Map<String, Field> load(Class<?> key) {
                return CachedPojoObjectMapper.this.createMetricClass(key);
            }
        });
    }

    @Override
    public <M> Table mapToTable(List<M> pojoObjects) {
        Ensures.ensureNonNull(pojoObjects, (String)"pojoObjects");
        Ensures.ensure((!pojoObjects.isEmpty() ? 1 : 0) != 0, (Object)"pojoObjects can not be empty");
        M first = pojoObjects.get(0);
        Class<?> metricType = first.getClass();
        Map fieldMap = (Map)this.classFieldCache.getUnchecked(metricType);
        String metricName = this.getMetricName(metricType);
        TableSchema.Builder schemaBuilder = TableSchema.newBuilder(metricName);
        for (Map.Entry entry : fieldMap.entrySet()) {
            String name = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            Column column = field.getAnnotation(Column.class);
            DataType dataType = column.dataType();
            SemanticType semanticType = SemanticType.Field;
            if (column.tag()) {
                semanticType = SemanticType.Tag;
            } else if (column.timestamp()) {
                semanticType = SemanticType.Timestamp;
            }
            schemaBuilder.addColumn(name, semanticType, dataType);
        }
        Table table = Table.from(schemaBuilder.build());
        for (M pojo : pojoObjects) {
            Class<?> type = pojo.getClass();
            if (!type.equals(metricType)) {
                throw new PojoException("All POJOs must be of the same type");
            }
            Object[] values = new Object[fieldMap.size()];
            int j = 0;
            for (Map.Entry entry : fieldMap.entrySet()) {
                Object value;
                Field field = (Field)entry.getValue();
                values[j] = value = this.getObject(pojo, field);
                ++j;
            }
            table.addRow(values);
        }
        return table;
    }

    private String getMetricName(Class<?> metricType) {
        Metric metricAnnotation = metricType.getAnnotation(Metric.class);
        if (metricAnnotation != null) {
            return metricAnnotation.name();
        }
        String err = String.format("Unable to determine Metric for '%s'. Does it have a @Metric annotation?", metricType);
        throw new PojoException(err);
    }

    private <M> Object getObject(M metric, Field field) {
        Object value;
        try {
            field.setAccessible(true);
            value = field.get(metric);
        }
        catch (IllegalAccessException e) {
            throw new PojoException(e);
        }
        return value;
    }

    private Map<String, Field> createMetricClass(Class<?> metricType) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Class<?> currentType = metricType; currentType != null; currentType = currentType.getSuperclass()) {
            for (Field field : currentType.getDeclaredFields()) {
                Column colAnnotation = field.getAnnotation(Column.class);
                if (colAnnotation == null) continue;
                fieldMap.put(colAnnotation.name(), field);
            }
        }
        return fieldMap;
    }
}

