/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignJobs {
    private static final Logger log = LoggerFactory.getLogger(AssignJobs.class);
    private Set<Long> jobs = ConcurrentHashMap.newKeySet(16);
    private Set<Long> addingJobs = ConcurrentHashMap.newKeySet(16);
    private Set<Long> removingJobs = ConcurrentHashMap.newKeySet(16);
    private Set<Long> pinnedJobs = ConcurrentHashMap.newKeySet(16);

    public void addAssignJob(Long jobId) {
        this.jobs.add(jobId);
    }

    public void addAddingJob(Long jobId) {
        this.addingJobs.add(jobId);
    }

    public void addRemovingJob(Long jobId) {
        this.removingJobs.add(jobId);
    }

    public void addPinnedJob(Long jobId) {
        this.pinnedJobs.add(jobId);
    }

    public void addAssignJobs(Set<Long> jobSet) {
        if (jobSet != null && !jobSet.isEmpty()) {
            this.jobs.addAll(jobSet);
        }
    }

    public void addAddingJobs(Set<Long> jobSet) {
        if (jobSet != null && !jobSet.isEmpty()) {
            this.addingJobs.addAll(jobSet);
        }
    }

    public void addRemovingJobs(Set<Long> jobSet) {
        if (jobSet != null && !jobSet.isEmpty()) {
            this.removingJobs.addAll(jobSet);
        }
    }

    public void addPinnedJobs(Set<Long> jobSet) {
        if (jobSet != null && !jobSet.isEmpty()) {
            this.pinnedJobs.addAll(jobSet);
        }
    }

    public void removeAssignJobs(Set<Long> jobIds) {
        if (this.jobs == null || jobIds == null || jobIds.isEmpty()) {
            return;
        }
        this.jobs.removeAll(jobIds);
    }

    public void removeAddingJobs(Set<Long> jobIds) {
        if (this.addingJobs == null || jobIds == null || jobIds.isEmpty()) {
            return;
        }
        this.addingJobs.removeAll(jobIds);
    }

    public void clearRemovingJobs() {
        if (this.removingJobs == null) {
            return;
        }
        this.removingJobs.clear();
    }

    public boolean containAndRemoveJob(Long jobId) {
        if (this.jobs.isEmpty()) {
            return false;
        }
        return this.jobs.remove(jobId);
    }

    public void removeAddingJob(Long jobId) {
        if (this.addingJobs == null || jobId == null) {
            return;
        }
        this.addingJobs.remove(jobId);
    }

    public void removeRemovingJob(Long jobId) {
        if (this.removingJobs == null || jobId == null) {
            return;
        }
        this.removingJobs.remove(jobId);
    }

    public void removePinnedJob(Long jobId) {
        if (this.pinnedJobs == null || jobId == null) {
            return;
        }
        this.pinnedJobs.remove(jobId);
    }

    public void clear() {
        if (!this.jobs.isEmpty()) {
            log.warn("assign jobs is not empty, maybe there are jobs not assigned");
            this.jobs.clear();
        }
    }

    public Set<Long> getJobs() {
        return this.jobs;
    }

    public Set<Long> getAddingJobs() {
        return this.addingJobs;
    }

    public Set<Long> getRemovingJobs() {
        return this.removingJobs;
    }

    public Set<Long> getPinnedJobs() {
        return this.pinnedJobs;
    }

    public void setJobs(Set<Long> jobs) {
        this.jobs = jobs;
    }

    public void setAddingJobs(Set<Long> addingJobs) {
        this.addingJobs = addingJobs;
    }

    public void setRemovingJobs(Set<Long> removingJobs) {
        this.removingJobs = removingJobs;
    }

    public void setPinnedJobs(Set<Long> pinnedJobs) {
        this.pinnedJobs = pinnedJobs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignJobs)) {
            return false;
        }
        AssignJobs other = (AssignJobs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Long> this$jobs = this.getJobs();
        Set<Long> other$jobs = other.getJobs();
        if (this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs)) {
            return false;
        }
        Set<Long> this$addingJobs = this.getAddingJobs();
        Set<Long> other$addingJobs = other.getAddingJobs();
        if (this$addingJobs == null ? other$addingJobs != null : !((Object)this$addingJobs).equals(other$addingJobs)) {
            return false;
        }
        Set<Long> this$removingJobs = this.getRemovingJobs();
        Set<Long> other$removingJobs = other.getRemovingJobs();
        if (this$removingJobs == null ? other$removingJobs != null : !((Object)this$removingJobs).equals(other$removingJobs)) {
            return false;
        }
        Set<Long> this$pinnedJobs = this.getPinnedJobs();
        Set<Long> other$pinnedJobs = other.getPinnedJobs();
        return !(this$pinnedJobs == null ? other$pinnedJobs != null : !((Object)this$pinnedJobs).equals(other$pinnedJobs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssignJobs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Long> $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        Set<Long> $addingJobs = this.getAddingJobs();
        result = result * 59 + ($addingJobs == null ? 43 : ((Object)$addingJobs).hashCode());
        Set<Long> $removingJobs = this.getRemovingJobs();
        result = result * 59 + ($removingJobs == null ? 43 : ((Object)$removingJobs).hashCode());
        Set<Long> $pinnedJobs = this.getPinnedJobs();
        result = result * 59 + ($pinnedJobs == null ? 43 : ((Object)$pinnedJobs).hashCode());
        return result;
    }

    public String toString() {
        return "AssignJobs(jobs=" + this.getJobs() + ", addingJobs=" + this.getAddingJobs() + ", removingJobs=" + this.getRemovingJobs() + ", pinnedJobs=" + this.getPinnedJobs() + ")";
    }
}

