/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncident;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.manager.pojo.dto.ComponentStatus;
import org.apache.hertzbeat.manager.service.StatusPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Status Page Public API")
@RestController
@RequestMapping(value={"/api/status/page/public"}, produces={"application/json"})
public class StatusPagePublicController {
    @Autowired
    private StatusPageService statusPageService;

    @GetMapping(value={"/org"})
    @Operation(summary="Query Status Page Organization")
    public ResponseEntity<Message<StatusPageOrg>> queryStatusPageOrg() {
        StatusPageOrg statusPageOrg = this.statusPageService.queryStatusPageOrg();
        if (statusPageOrg == null) {
            return ResponseEntity.ok(Message.fail((byte)15, "Status Page Organization Not Found"));
        }
        return ResponseEntity.ok(Message.success(statusPageOrg));
    }

    @GetMapping(value={"/component"})
    @Operation(summary="Query Status Page Components")
    public ResponseEntity<Message<List<ComponentStatus>>> queryStatusPageComponent() {
        List<ComponentStatus> componentStatusList = this.statusPageService.queryComponentsStatus();
        return ResponseEntity.ok(Message.success(componentStatusList));
    }

    @GetMapping(value={"/component/{id}"})
    @Operation(summary="Query Status Page Component")
    public ResponseEntity<Message<ComponentStatus>> queryStatusPageComponent(@PathVariable(value="id") long id) {
        ComponentStatus componentStatus = this.statusPageService.queryComponentStatus(id);
        return ResponseEntity.ok(Message.success(componentStatus));
    }

    @GetMapping(value={"/incident"})
    @Operation(summary="Query Status Page Incidents")
    public ResponseEntity<Message<List<StatusPageIncident>>> queryStatusPageIncident() {
        List<StatusPageIncident> incidents = this.statusPageService.queryStatusPageIncidents();
        return ResponseEntity.ok(Message.success(incidents));
    }
}

