/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.ws.ResponseFuture;
import com.taosdata.jdbc.ws.entity.Action;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class InFlightRequest {
    private final int timeoutSec;
    private final Semaphore semaphore;
    private Map<String, ConcurrentHashMap<Long, ResponseFuture>> futureMap = new HashMap<String, ConcurrentHashMap<Long, ResponseFuture>>();
    private Map<String, PriorityBlockingQueue<ResponseFuture>> expireMap = new HashMap<String, PriorityBlockingQueue<ResponseFuture>>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setName("timer-" + t.getId());
        return t;
    });

    public InFlightRequest(int timeoutSec, int concurrentNum) {
        this.timeoutSec = timeoutSec;
        this.semaphore = new Semaphore(concurrentNum);
        this.scheduledExecutorService.scheduleWithFixedDelay(this::removeTimeoutFuture, timeoutSec, timeoutSec, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this.scheduledExecutorService::shutdown));
        for (Action value : Action.values()) {
            String action = value.getAction();
            if (Action.CONN.getAction().equals(action)) continue;
            this.futureMap.put(action, new ConcurrentHashMap());
            this.expireMap.put(action, new PriorityBlockingQueue());
        }
    }

    public void put(ResponseFuture rf) throws InterruptedException, TimeoutException {
        if (!this.semaphore.tryAcquire(this.timeoutSec, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        this.futureMap.get(rf.getAction()).put(rf.getId(), rf);
        this.expireMap.get(rf.getAction()).put(rf);
    }

    public ResponseFuture remove(String action, Long id) {
        ResponseFuture future = this.futureMap.get(action).remove(id);
        if (null != future) {
            this.expireMap.get(action).remove(future);
            this.semaphore.release();
        }
        return future;
    }

    private void removeTimeoutFuture() {
        this.expireMap.forEach((k, v) -> {
            ResponseFuture response;
            while (null != (response = (ResponseFuture)v.peek()) && System.nanoTime() - response.getTimestamp() >= (long)this.timeoutSec * 1000000L) {
                try {
                    v.poll();
                    this.futureMap.get(k).remove(response.getId());
                    response.getFuture().completeExceptionally(new TimeoutException());
                }
                finally {
                    this.semaphore.release();
                }
            }
        });
    }

    public void close() {
        ((Stream)this.expireMap.keySet().stream().flatMap(k -> {
            PriorityBlockingQueue<ResponseFuture> futures = this.expireMap.get(k);
            this.expireMap.put((String)k, new PriorityBlockingQueue());
            this.futureMap.put((String)k, new ConcurrentHashMap());
            return futures.stream();
        }).parallel()).map(ResponseFuture::getFuture).forEach(e -> e.completeExceptionally(new Exception("close all inFlightRequest")));
        this.scheduledExecutorService.shutdown();
    }
}

