/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.kerberos;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.sun.security.auth.module.Krb5LoginModule;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.auth.kerberos.AbstractUnconstrainedContextProvider;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSException;

public class LoginBasedUnconstrainedContextProvider
extends AbstractUnconstrainedContextProvider {
    private final Optional<String> principal;
    private final Optional<File> keytab;
    private final Optional<File> credentialCache;
    @GuardedBy(value="this")
    private LoginContext loginContext;

    public LoginBasedUnconstrainedContextProvider(Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache) {
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.keytab = Objects.requireNonNull(keytab, "keytab is null");
        this.credentialCache = Objects.requireNonNull(credentialCache, "credentialCache is null");
        kerberosConfig.ifPresent(file -> {
            String newValue = file.getAbsolutePath();
            String currentValue = System.getProperty("java.security.krb5.conf");
            Preconditions.checkState(currentValue == null || Objects.equals(currentValue, newValue), "Refusing to set system property 'java.security.krb5.conf' to '%s', it is already set to '%s'", (Object)newValue, (Object)currentValue);
            Preconditions.checkState(file.exists() && !file.isDirectory(), "Kerberos config file '%s' does not exist or is a directory", (Object)newValue);
            Preconditions.checkState(file.canRead(), "Kerberos config file '%s' is not readable", (Object)newValue);
            System.setProperty("java.security.krb5.conf", newValue);
        });
    }

    @Override
    public Subject getSubject() {
        return this.loginContext.getSubject();
    }

    @Override
    public void refresh() throws GSSException {
        try {
            this.loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
                    options.put("refreshKrb5Config", "true");
                    options.put("doNotPrompt", "true");
                    options.put("useKeyTab", "true");
                    if (Boolean.getBoolean("trino.client.debugKerberos")) {
                        options.put("debug", "true");
                    }
                    LoginBasedUnconstrainedContextProvider.this.keytab.ifPresent(file -> options.put("keyTab", file.getAbsolutePath()));
                    LoginBasedUnconstrainedContextProvider.this.credentialCache.ifPresent(file -> {
                        options.put("ticketCache", file.getAbsolutePath());
                        options.put("renewTGT", "true");
                    });
                    if (!LoginBasedUnconstrainedContextProvider.this.keytab.isPresent() || LoginBasedUnconstrainedContextProvider.this.credentialCache.isPresent()) {
                        options.put("useTicketCache", "true");
                    }
                    LoginBasedUnconstrainedContextProvider.this.principal.ifPresent(value -> options.put("principal", (String)value));
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options.buildOrThrow())};
                }
            });
            this.loginContext.login();
        }
        catch (LoginException e) {
            throw new ClientException(String.format("Kerberos login error for [%s]: %s", this.principal.orElse("not defined"), e.getMessage()), e);
        }
    }
}

