/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.iceberg;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.CharType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;

public class IcebergDataTypeTransformer
extends GeneralDataTypeTransformer {
    @Override
    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == CharType.class) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Iceberg does not support the datatype CHAR");
        }
        if (typeClass == VarcharType.class) {
            VarcharType varCharType = (VarcharType)type;
            if (varCharType.getLength().isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Iceberg does not support the datatype VARCHAR with length");
            }
            return Types.StringType.get();
        }
        return super.getGravitinoType(type);
    }

    @Override
    public io.trino.spi.type.Type getTrinoType(Type type) {
        if (Type.Name.FIXED == type.name()) {
            return VarbinaryType.VARBINARY;
        }
        if (Type.Name.TIME == type.name()) {
            return TimeType.TIME_MICROS;
        }
        if (Type.Name.TIMESTAMP == type.name()) {
            Types.TimestampType timestampType = (Types.TimestampType)type;
            if (timestampType.hasTimeZone()) {
                return TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
            }
            return TimestampType.TIMESTAMP_MICROS;
        }
        return super.getTrinoType(type);
    }
}

