/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMetaService {
    private static final Logger LOG = LoggerFactory.getLogger(ModelMetaService.class);
    private static final ModelMetaService INSTANCE = new ModelMetaService();

    public static ModelMetaService getInstance() {
        return INSTANCE;
    }

    private ModelMetaService() {
    }

    public List<ModelEntity> listModelsByNamespace(Namespace ns) {
        NamespaceUtil.checkModel(ns);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(ns);
        List modelPOs = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.listModelPOsBySchemaId(schemaId));
        return modelPOs.stream().map(m -> POConverters.fromModelPO(m, ns)).collect(Collectors.toList());
    }

    public ModelEntity getModelByIdentifier(NameIdentifier ident) {
        ModelPO modelPO = this.getModelPOByIdentifier(ident);
        return POConverters.fromModelPO(modelPO, ident.namespace());
    }

    public void insertModel(ModelEntity modelEntity, boolean overwrite) throws IOException {
        NameIdentifierUtil.checkModel(modelEntity.nameIdentifier());
        try {
            ModelPO.Builder builder = ModelPO.builder();
            this.fillModelPOBuilderParentEntityId(builder, modelEntity.namespace());
            SessionUtils.doWithCommit(ModelMetaMapper.class, mapper -> {
                ModelPO po = POConverters.initializeModelPO(modelEntity, builder);
                if (overwrite) {
                    mapper.insertModelMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertModelMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL, modelEntity.nameIdentifier().toString());
            throw re;
        }
    }

    public boolean deleteModel(NameIdentifier ident) {
        Long modelId;
        Long schemaId;
        NameIdentifierUtil.checkModel(ident);
        try {
            schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(ident.namespace());
            modelId = this.getModelIdBySchemaIdAndModelName(schemaId, ident.name());
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Failed to delete model: {}", (Object)ident, (Object)e);
            return false;
        }
        AtomicInteger modelDeletedCount = new AtomicInteger();
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.softDeleteModelVersionsBySchemaIdAndModelName(schemaId, ident.name())), () -> SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.softDeleteModelVersionAliasRelsBySchemaIdAndModelName(schemaId, ident.name())), () -> modelDeletedCount.set(SessionUtils.doWithoutCommitAndFetchResult(ModelMetaMapper.class, mapper -> mapper.softDeleteModelMetaBySchemaIdAndModelName(schemaId, ident.name()))), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(modelId, MetadataObject.Type.MODEL.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(modelId, MetadataObject.Type.MODEL.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(modelId, MetadataObject.Type.MODEL.name())));
        return modelDeletedCount.get() > 0;
    }

    public int deleteModelMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(ModelMetaMapper.class, mapper -> mapper.deleteModelMetasByLegacyTimeline(legacyTimeline, limit));
    }

    Long getModelIdBySchemaIdAndModelName(Long schemaId, String modelName) {
        Long modelId = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelIdBySchemaIdAndModelName(schemaId, modelName));
        if (modelId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), modelName});
        }
        return modelId;
    }

    ModelPO getModelPOById(Long modelId) {
        ModelPO modelPO = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelMetaByModelId(modelId));
        if (modelPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), modelId.toString()});
        }
        return modelPO;
    }

    private void fillModelPOBuilderParentEntityId(ModelPO.Builder builder, Namespace ns) {
        NamespaceUtil.checkModel(ns);
        Long[] parentEntityIds = CommonMetaService.getInstance().getParentEntityIdsByNamespace(ns);
        builder.withMetalakeId(parentEntityIds[0]);
        builder.withCatalogId(parentEntityIds[1]);
        builder.withSchemaId(parentEntityIds[2]);
    }

    ModelPO getModelPOByIdentifier(NameIdentifier ident) {
        NameIdentifierUtil.checkModel(ident);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(ident.namespace());
        ModelPO modelPO = SessionUtils.getWithoutCommit(ModelMetaMapper.class, mapper -> mapper.selectModelMetaBySchemaIdAndModelName(schemaId, ident.name()));
        if (modelPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        return modelPO;
    }

    public <E extends Entity & HasIdentifier> ModelEntity updateModel(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkModel(identifier);
        ModelPO oldModelPO = this.getModelPOByIdentifier(identifier);
        ModelEntity oldModelEntity = POConverters.fromModelPO(oldModelPO, identifier.namespace());
        ModelEntity newEntity = (ModelEntity)updater.apply(oldModelEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldModelEntity.id(), newEntity.id()), (String)"The updated model entity id: %s should be same with the table entity id before: %s", (Object)newEntity.id(), (Object)oldModelEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(ModelMetaMapper.class, mapper -> mapper.updateModelMeta(POConverters.updateModelPO(oldModelPO, newEntity), oldModelPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.CATALOG, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + identifier);
    }
}

