/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.ImmutableViewVersion;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewUtil;
import org.apache.iceberg.view.ViewVersion;

public abstract class BaseMetastoreViewCatalog
extends BaseMetastoreCatalog
implements ViewCatalog {
    protected abstract ViewOperations newViewOps(TableIdentifier var1);

    public void initialize(String name, Map<String, String> properties) {
        super.initialize(name, properties);
    }

    public String name() {
        return super.name();
    }

    public View loadView(TableIdentifier identifier) {
        if (this.isValidIdentifier(identifier)) {
            ViewOperations ops = this.newViewOps(identifier);
            if (ops.current() == null) {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{identifier});
            }
            return new BaseView(this.newViewOps(identifier), ViewUtil.fullViewName(this.name(), identifier));
        }
        throw new NoSuchViewException("Invalid view identifier: %s", new Object[]{identifier});
    }

    public ViewBuilder buildView(TableIdentifier identifier) {
        return new BaseViewBuilder(identifier);
    }

    @Override
    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new BaseMetastoreViewCatalogTableBuilder(identifier, schema);
    }

    protected class BaseMetastoreViewCatalogTableBuilder
    extends BaseMetastoreCatalog.BaseMetastoreCatalogTableBuilder {
        private final TableIdentifier identifier;

        public BaseMetastoreViewCatalogTableBuilder(TableIdentifier identifier, Schema schema) {
            super(identifier, schema);
            this.identifier = identifier;
        }

        @Override
        public Transaction replaceTransaction() {
            if (BaseMetastoreViewCatalog.this.viewExists(this.identifier)) {
                throw new AlreadyExistsException("View with same name already exists: %s", new Object[]{this.identifier});
            }
            return super.replaceTransaction();
        }
    }

    protected class BaseViewBuilder
    implements ViewBuilder {
        private final TableIdentifier identifier;
        private final Map<String, String> properties = Maps.newHashMap();
        private final List<ViewRepresentation> representations = Lists.newArrayList();
        private Namespace defaultNamespace = null;
        private String defaultCatalog = null;
        private Schema schema = null;
        private String location = null;

        protected BaseViewBuilder(TableIdentifier identifier) {
            Preconditions.checkArgument((boolean)BaseMetastoreViewCatalog.this.isValidIdentifier(identifier), (String)"Invalid view identifier: %s", (Object)identifier);
            this.identifier = identifier;
        }

        public ViewBuilder withSchema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ViewBuilder withQuery(String dialect, String sql) {
            this.representations.add((ViewRepresentation)ImmutableSQLViewRepresentation.builder().dialect(dialect).sql(sql).build());
            return this;
        }

        public ViewBuilder withDefaultCatalog(String catalog) {
            this.defaultCatalog = catalog;
            return this;
        }

        public ViewBuilder withDefaultNamespace(Namespace namespace) {
            this.defaultNamespace = namespace;
            return this;
        }

        public ViewBuilder withProperties(Map<String, String> newProperties) {
            this.properties.putAll(newProperties);
            return this;
        }

        public ViewBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public ViewBuilder withLocation(String newLocation) {
            this.location = newLocation;
            return this;
        }

        public View create() {
            return this.create(BaseMetastoreViewCatalog.this.newViewOps(this.identifier));
        }

        public View replace() {
            return this.replace(BaseMetastoreViewCatalog.this.newViewOps(this.identifier));
        }

        public View createOrReplace() {
            ViewOperations ops = BaseMetastoreViewCatalog.this.newViewOps(this.identifier);
            if (null == ops.current()) {
                return this.create(ops);
            }
            return this.replace(ops);
        }

        private View create(ViewOperations ops) {
            if (null != ops.current()) {
                throw new AlreadyExistsException("View already exists: %s", new Object[]{this.identifier});
            }
            Preconditions.checkState((!this.representations.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create view without specifying a query");
            Preconditions.checkState((null != this.schema ? 1 : 0) != 0, (Object)"Cannot create view without specifying schema");
            Preconditions.checkState((null != this.defaultNamespace ? 1 : 0) != 0, (Object)"Cannot create view without specifying a default namespace");
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            ViewMetadata viewMetadata = ViewMetadata.builder().setProperties(this.properties).setLocation(null != this.location ? this.location : BaseMetastoreViewCatalog.this.defaultWarehouseLocation(this.identifier)).setCurrentVersion(viewVersion, this.schema).build();
            try {
                ops.commit(null, viewMetadata);
            }
            catch (CommitFailedException ignored) {
                throw new AlreadyExistsException("View was created concurrently: %s", new Object[]{this.identifier});
            }
            return new BaseView(ops, ViewUtil.fullViewName(BaseMetastoreViewCatalog.this.name(), this.identifier));
        }

        private View replace(ViewOperations ops) {
            if (BaseMetastoreViewCatalog.this.tableExists(this.identifier)) {
                throw new AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.identifier});
            }
            if (null == ops.current()) {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{this.identifier});
            }
            Preconditions.checkState((!this.representations.isEmpty() ? 1 : 0) != 0, (Object)"Cannot replace view without specifying a query");
            Preconditions.checkState((null != this.schema ? 1 : 0) != 0, (Object)"Cannot replace view without specifying schema");
            Preconditions.checkState((null != this.defaultNamespace ? 1 : 0) != 0, (Object)"Cannot replace view without specifying a default namespace");
            ViewMetadata metadata = ops.current();
            int maxVersionId = metadata.versions().stream().map(ViewVersion::versionId).max(Integer::compareTo).orElseGet(metadata::currentVersionId);
            ImmutableViewVersion viewVersion = ImmutableViewVersion.builder().versionId(maxVersionId + 1).schemaId(this.schema.schemaId()).addAllRepresentations(this.representations).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).timestampMillis(System.currentTimeMillis()).putAllSummary(EnvironmentContext.get()).build();
            ViewMetadata.Builder builder = ViewMetadata.buildFrom(metadata).setProperties(this.properties).setCurrentVersion(viewVersion, this.schema);
            if (null != this.location) {
                builder.setLocation(this.location);
            }
            ViewMetadata replacement = builder.build();
            try {
                ops.commit(metadata, replacement);
            }
            catch (CommitFailedException ignored) {
                throw new AlreadyExistsException("View was updated concurrently: %s", new Object[]{this.identifier});
            }
            return new BaseView(ops, ViewUtil.fullViewName(BaseMetastoreViewCatalog.this.name(), this.identifier));
        }
    }
}

