/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelVersion;

public class ModelNormalizeDispatcher
implements ModelDispatcher {
    private final CatalogManager catalogManager;
    private final ModelDispatcher dispatcher;

    public ModelNormalizeDispatcher(ModelDispatcher dispatcher, CatalogManager catalogManager) {
        this.dispatcher = dispatcher;
        this.catalogManager = catalogManager;
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        Namespace caseSensitiveNs = this.normalizeCaseSensitive(namespace);
        NameIdentifier[] identifiers = this.dispatcher.listModels(caseSensitiveNs);
        return this.normalizeCaseSensitive(identifiers);
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        return this.dispatcher.getModel(this.normalizeCaseSensitive(ident));
    }

    public boolean modelExists(NameIdentifier ident) {
        return this.dispatcher.modelExists(this.normalizeCaseSensitive(ident));
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException {
        return this.dispatcher.registerModel(this.normalizeNameIdentifier(ident), comment, properties);
    }

    public boolean deleteModel(NameIdentifier ident) {
        return this.dispatcher.deleteModel(this.normalizeCaseSensitive(ident));
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        return this.dispatcher.listModelVersions(this.normalizeCaseSensitive(ident));
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        return this.dispatcher.getModelVersion(this.normalizeCaseSensitive(ident), version);
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        return this.dispatcher.getModelVersion(this.normalizeCaseSensitive(ident), alias);
    }

    public boolean modelVersionExists(NameIdentifier ident, int version) {
        return this.dispatcher.modelVersionExists(this.normalizeCaseSensitive(ident), version);
    }

    public boolean modelVersionExists(NameIdentifier ident, String alias) {
        return this.dispatcher.modelVersionExists(this.normalizeCaseSensitive(ident), alias);
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        this.dispatcher.linkModelVersion(this.normalizeCaseSensitive(ident), uri, aliases, comment, properties);
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        return this.dispatcher.deleteModelVersion(this.normalizeCaseSensitive(ident), version);
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        return this.dispatcher.deleteModelVersion(this.normalizeCaseSensitive(ident), alias);
    }

    private Namespace normalizeCaseSensitive(Namespace namespace) {
        Capability capabilities = CapabilityHelpers.getCapability(NameIdentifier.of((String[])namespace.levels()), this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(namespace, Capability.Scope.MODEL, capabilities);
    }

    private NameIdentifier normalizeCaseSensitive(NameIdentifier ident) {
        Capability capabilities = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(ident, Capability.Scope.MODEL, capabilities);
    }

    private NameIdentifier[] normalizeCaseSensitive(NameIdentifier[] idents) {
        if (ArrayUtils.isEmpty((Object[])idents)) {
            return idents;
        }
        Capability capabilities = CapabilityHelpers.getCapability(idents[0], this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(idents, Capability.Scope.MODEL, capabilities);
    }

    private NameIdentifier normalizeNameIdentifier(NameIdentifier ident) {
        Capability capability = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return CapabilityHelpers.applyCapabilities(ident, Capability.Scope.MODEL, capability);
    }
}

