/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.model.Model;

public final class EntityCombinedModel
implements Model {
    private final Model model;
    private final ModelEntity modelEntity;
    private Set<String> hiddenProperties = Collections.emptySet();

    private EntityCombinedModel(Model model, ModelEntity modelEntity) {
        this.model = model;
        this.modelEntity = modelEntity;
    }

    public static EntityCombinedModel of(Model model, ModelEntity modelEntity) {
        return new EntityCombinedModel(model, modelEntity);
    }

    public static EntityCombinedModel of(Model model) {
        return new EntityCombinedModel(model, null);
    }

    public EntityCombinedModel withHiddenProperties(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties;
        return this;
    }

    public String name() {
        return this.model.name();
    }

    public String comment() {
        return this.model.comment();
    }

    public Map<String, String> properties() {
        return this.model.properties() == null ? null : this.model.properties().entrySet().stream().filter(e -> !this.hiddenProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public int latestVersion() {
        return this.model.latestVersion();
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.model.auditInfo().creator()).withCreateTime(this.model.auditInfo().createTime()).withLastModifier(this.model.auditInfo().lastModifier()).withLastModifiedTime(this.model.auditInfo().lastModifiedTime()).build();
        return this.modelEntity == null ? mergedAudit : mergedAudit.merge(this.modelEntity.auditInfo(), true);
    }
}

