/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.model;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelVersion;

@Evolving
public interface ModelCatalog {
    public NameIdentifier[] listModels(Namespace var1) throws NoSuchSchemaException;

    public Model getModel(NameIdentifier var1) throws NoSuchModelException;

    default public boolean modelExists(NameIdentifier ident) {
        try {
            this.getModel(ident);
            return true;
        }
        catch (NoSuchModelException e) {
            return false;
        }
    }

    public Model registerModel(NameIdentifier var1, String var2, Map<String, String> var3) throws NoSuchSchemaException, ModelAlreadyExistsException;

    default public Model registerModel(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException, ModelVersionAliasesAlreadyExistException {
        Model model = this.registerModel(ident, comment, properties);
        this.linkModelVersion(ident, uri, aliases, comment, properties);
        return model;
    }

    public boolean deleteModel(NameIdentifier var1);

    public int[] listModelVersions(NameIdentifier var1) throws NoSuchModelException;

    public ModelVersion getModelVersion(NameIdentifier var1, int var2) throws NoSuchModelVersionException;

    public ModelVersion getModelVersion(NameIdentifier var1, String var2) throws NoSuchModelVersionException;

    default public boolean modelVersionExists(NameIdentifier ident, int version) {
        try {
            this.getModelVersion(ident, version);
            return true;
        }
        catch (NoSuchModelVersionException e) {
            return false;
        }
    }

    default public boolean modelVersionExists(NameIdentifier ident, String alias) {
        try {
            this.getModelVersion(ident, alias);
            return true;
        }
        catch (NoSuchModelVersionException e) {
            return false;
        }
    }

    public void linkModelVersion(NameIdentifier var1, String var2, String[] var3, String var4, Map<String, String> var5) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException;

    public boolean deleteModelVersion(NameIdentifier var1, int var2);

    public boolean deleteModelVersion(NameIdentifier var1, String var2);
}

