/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.exceptions.IllegalNameIdentifierException;
import org.apache.gravitino.exceptions.IllegalNamespaceException;
import org.apache.gravitino.utils.NamespaceUtil;

public class NameIdentifierUtil {
    private NameIdentifierUtil() {
    }

    public static NameIdentifier ofMetalake(String metalake) {
        return NameIdentifier.of((String[])new String[]{metalake});
    }

    public static NameIdentifier ofCatalog(String metalake, String catalog) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog});
    }

    public static NameIdentifier ofSchema(String metalake, String catalog, String schema) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema});
    }

    public static NameIdentifier ofTable(String metalake, String catalog, String schema, String table) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table});
    }

    public static NameIdentifier ofTag(String metalake, String tagName) {
        return NameIdentifier.of((Namespace)NamespaceUtil.ofTag(metalake), (String)tagName);
    }

    public static NameIdentifier ofColumn(String metalake, String catalog, String schema, String table, String column) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table, column});
    }

    public static NameIdentifier ofFileset(String metalake, String catalog, String schema, String fileset) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, fileset});
    }

    public static NameIdentifier ofTopic(String metalake, String catalog, String schema, String topic) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, topic});
    }

    public static NameIdentifier ofModel(String metalake, String catalog, String schema, String model) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, model});
    }

    public static NameIdentifier toModelIdentifier(Namespace modelVersionNs) {
        return NameIdentifier.of((String[])modelVersionNs.levels());
    }

    public static NameIdentifier toModelIdentifier(NameIdentifier modelIdent) {
        return NameIdentifier.of((String[])modelIdent.namespace().levels());
    }

    public static NameIdentifier ofModelVersion(String metalake, String catalog, String schema, String model, int version) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, model, String.valueOf(version)});
    }

    public static NameIdentifier ofModelVersion(String metalake, String catalog, String schema, String model, String alias) {
        return NameIdentifier.of((String[])new String[]{metalake, catalog, schema, model, alias});
    }

    public static NameIdentifier toModelVersionIdentifier(NameIdentifier modelIdent, int version) {
        return NameIdentifierUtil.ofModelVersion(modelIdent.namespace().level(0), modelIdent.namespace().level(1), modelIdent.namespace().level(2), modelIdent.name(), version);
    }

    public static NameIdentifier toModelVersionIdentifier(NameIdentifier modelIdent, String alias) {
        return NameIdentifierUtil.ofModelVersion(modelIdent.namespace().level(0), modelIdent.namespace().level(1), modelIdent.namespace().level(2), modelIdent.name(), alias);
    }

    public static NameIdentifier getCatalogIdentifier(NameIdentifier ident) throws IllegalNameIdentifierException {
        NameIdentifier.check((ident.name() != null && !ident.name().isEmpty() ? 1 : 0) != 0, (String)"The name variable in the NameIdentifier must have value.", (Object[])new Object[0]);
        Namespace.check((ident.namespace() != null && !ident.namespace().isEmpty() ? 1 : 0) != 0, (String)"Catalog namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{ident.namespace()});
        List allElems = Stream.concat(Arrays.stream(ident.namespace().levels()), Stream.of(ident.name())).collect(Collectors.toList());
        if (allElems.size() < 2) {
            throw new IllegalNameIdentifierException("Cannot create a catalog NameIdentifier less than two elements.", new Object[0]);
        }
        return NameIdentifier.of((String[])new String[]{(String)allElems.get(0), (String)allElems.get(1)});
    }

    public static NameIdentifier getSchemaIdentifier(NameIdentifier ident) throws IllegalNameIdentifierException {
        NameIdentifier.check((ident.name() != null && !ident.name().isEmpty() ? 1 : 0) != 0, (String)"The name variable in the NameIdentifier must have value.", (Object[])new Object[0]);
        Namespace.check((ident.namespace() != null && !ident.namespace().isEmpty() && ident.namespace().length() > 1 ? 1 : 0) != 0, (String)"Schema namespace must be non-null and at least 1 level, the input namespace is %s", (Object[])new Object[]{ident.namespace()});
        List allElems = Stream.concat(Arrays.stream(ident.namespace().levels()), Stream.of(ident.name())).collect(Collectors.toList());
        if (allElems.size() < 3) {
            throw new IllegalNameIdentifierException("Cannot create a schema NameIdentifier less than three elements.", new Object[0]);
        }
        return NameIdentifier.of((String[])new String[]{(String)allElems.get(0), (String)allElems.get(1), (String)allElems.get(2)});
    }

    public static void checkMetalake(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Metalake identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkMetalake(ident.namespace());
    }

    public static void checkCatalog(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Catalog identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkCatalog(ident.namespace());
    }

    public static void checkSchema(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Schema identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkSchema(ident.namespace());
    }

    public static void checkTable(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Table identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkTable(ident.namespace());
    }

    public static void checkColumn(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Column identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkColumn(ident.namespace());
    }

    public static void checkFileset(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Fileset identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkFileset(ident.namespace());
    }

    public static void checkTopic(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Topic identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkTopic(ident.namespace());
    }

    public static void checkModel(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Model identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkModel(ident.namespace());
    }

    public static void checkModelVersion(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Model version identifier must not be null", (Object[])new Object[0]);
        NamespaceUtil.checkModelVersion(ident.namespace());
    }

    @FormatMethod
    public static void check(boolean expression, @FormatString String message, Object ... args) {
        if (!expression) {
            throw new IllegalNamespaceException(message, args);
        }
    }

    public static MetadataObject toMetadataObject(NameIdentifier ident, Entity.EntityType entityType) {
        Preconditions.checkArgument((ident != null && entityType != null ? 1 : 0) != 0, (Object)"The identifier and entity type must not be null");
        Joiner dot = Joiner.on((String)".");
        switch (entityType) {
            case METALAKE: {
                NameIdentifierUtil.checkMetalake(ident);
                return MetadataObjects.of(null, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.METALAKE);
            }
            case CATALOG: {
                NameIdentifierUtil.checkCatalog(ident);
                return MetadataObjects.of(null, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.CATALOG);
            }
            case SCHEMA: {
                NameIdentifierUtil.checkSchema(ident);
                String schemaParent = ident.namespace().level(1);
                return MetadataObjects.of((String)schemaParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.SCHEMA);
            }
            case TABLE: {
                NameIdentifierUtil.checkTable(ident);
                String tableParent = dot.join((Object)ident.namespace().level(1), (Object)ident.namespace().level(2), new Object[0]);
                return MetadataObjects.of((String)tableParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.TABLE);
            }
            case COLUMN: {
                NameIdentifierUtil.checkColumn(ident);
                Namespace columnNs = ident.namespace();
                String columnParent = dot.join((Object)columnNs.level(1), (Object)columnNs.level(2), new Object[]{columnNs.level(3)});
                return MetadataObjects.of((String)columnParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.COLUMN);
            }
            case FILESET: {
                NameIdentifierUtil.checkFileset(ident);
                String filesetParent = dot.join((Object)ident.namespace().level(1), (Object)ident.namespace().level(2), new Object[0]);
                return MetadataObjects.of((String)filesetParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.FILESET);
            }
            case TOPIC: {
                NameIdentifierUtil.checkTopic(ident);
                String topicParent = dot.join((Object)ident.namespace().level(1), (Object)ident.namespace().level(2), new Object[0]);
                return MetadataObjects.of((String)topicParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.TOPIC);
            }
            case MODEL: {
                NameIdentifierUtil.checkModel(ident);
                String modelParent = dot.join((Object)ident.namespace().level(1), (Object)ident.namespace().level(2), new Object[0]);
                return MetadataObjects.of((String)modelParent, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.MODEL);
            }
            case ROLE: {
                AuthorizationUtils.checkRole(ident);
                return MetadataObjects.of(null, (String)ident.name(), (MetadataObject.Type)MetadataObject.Type.ROLE);
            }
        }
        throw new IllegalArgumentException("Entity type " + (Object)((Object)entityType) + " is not supported to convert to MetadataObject");
    }

    public static String getMetalake(NameIdentifier identifier) {
        if (identifier.hasNamespace()) {
            return identifier.namespace().level(0);
        }
        return identifier.name();
    }
}

