/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.config.CredentialConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialCache<T>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialCache.class);
    private Cache<T, Credential> credentialCache;

    public void initialize(Map<String, String> catalogProperties) {
        CredentialConfig credentialConfig = new CredentialConfig(catalogProperties);
        long cacheSize = credentialConfig.get(CredentialConfig.CREDENTIAL_CACHE_MAX_SIZE);
        double cacheExpireRatio = credentialConfig.get(CredentialConfig.CREDENTIAL_CACHE_EXPIRE_RATIO);
        this.credentialCache = Caffeine.newBuilder().expireAfter(new CredentialExpireTimeCalculator(cacheExpireRatio)).maximumSize(cacheSize).removalListener((cacheKey, credential, c) -> LOG.debug("Credential expire, cache key: {}.", cacheKey)).build();
    }

    public Credential getCredential(T cacheKey, Function<T, Credential> credentialSupplier) {
        return (Credential)this.credentialCache.get(cacheKey, key -> (Credential)credentialSupplier.apply(cacheKey));
    }

    @Override
    public void close() throws IOException {
        if (this.credentialCache != null) {
            this.credentialCache.invalidateAll();
            this.credentialCache = null;
        }
    }

    static class CredentialExpireTimeCalculator<T>
    implements Expiry<T, Credential> {
        private double credentialCacheExpireRatio;

        public CredentialExpireTimeCalculator(double credentialCacheExpireRatio) {
            this.credentialCacheExpireRatio = credentialCacheExpireRatio;
        }

        public long expireAfterCreate(T key, Credential credential, long currentTime) {
            long credentialExpireTime = credential.expireTimeInMs();
            long timeToExpire = credentialExpireTime - System.currentTimeMillis();
            if (timeToExpire <= 0L) {
                return 0L;
            }
            timeToExpire = (long)((double)timeToExpire * this.credentialCacheExpireRatio);
            return TimeUnit.MILLISECONDS.toNanos(timeToExpire);
        }

        public long expireAfterUpdate(T key, Credential value, long currentTime, long currentDuration) {
            return currentDuration;
        }

        public long expireAfterRead(T key, Credential value, long currentTime, long currentDuration) {
            return currentDuration;
        }
    }
}

