/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.util.Tasks;

public class SetLocation
implements UpdateLocation {
    private final TableOperations ops;
    private String newLocation;

    public SetLocation(TableOperations ops) {
        this.ops = ops;
        this.newLocation = null;
    }

    public UpdateLocation setLocation(String location) {
        this.newLocation = location;
        return this;
    }

    public String apply() {
        return this.newLocation;
    }

    public void commit() {
        TableMetadata base = this.ops.refresh();
        Tasks.foreach(this.ops).retry(base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(base.propertyAsInt("commit.retry.min-wait-ms", 100), base.propertyAsInt("commit.retry.max-wait-ms", 60000), base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(base, base.updateLocation(this.newLocation)));
    }
}

