/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.response;

import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.request.ApRequest;
import org.apache.kerby.kerberos.kerb.type.ap.ApRep;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.kerby.kerberos.kerb.type.ap.EncAPRepPart;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class ApResponse {
    private ApReq apReq;
    private ApRep apRep;
    EncryptionKey encryptionKey;

    public ApResponse(ApReq apReq, EncryptionKey encryptionKey) {
        this.apReq = apReq;
        this.encryptionKey = encryptionKey;
    }

    public ApResponse(ApReq apReq) {
        this.apReq = apReq;
    }

    public ApRep getApRep() throws KrbException {
        if (this.encryptionKey != null) {
            ApRequest.validate(this.encryptionKey, this.apReq);
        }
        if (this.apRep == null) {
            this.apRep = this.makeApRep();
        }
        return this.apRep;
    }

    public void setApRep(ApRep apRep) {
        this.apRep = apRep;
    }

    private ApRep makeApRep() throws KrbException {
        ApRep apRep = new ApRep();
        EncAPRepPart encAPRepPart = new EncAPRepPart();
        Authenticator auth = this.apReq.getAuthenticator();
        encAPRepPart.setCtime(auth.getCtime());
        encAPRepPart.setCusec(auth.getCusec());
        encAPRepPart.setSubkey(auth.getSubKey());
        encAPRepPart.setSeqNumber(Integer.valueOf(0));
        apRep.setEncRepPart(encAPRepPart);
        EncryptedData encPart = EncryptionUtil.seal((Asn1Encodeable)encAPRepPart, auth.getSubKey(), KeyUsage.AP_REP_ENCPART);
        apRep.setEncryptedEncPart(encPart);
        return apRep;
    }

    public static void validate(EncryptionKey encKey, ApRep apRep, ApReq apReqSent) throws KrbException {
        EncAPRepPart encPart = EncryptionUtil.unseal(apRep.getEncryptedEncPart(), encKey, KeyUsage.AP_REP_ENCPART, EncAPRepPart.class);
        apRep.setEncRepPart(encPart);
        if (apReqSent != null) {
            Authenticator auth = apReqSent.getAuthenticator();
            if (!encPart.getCtime().equals((Object)auth.getCtime()) || encPart.getCusec() != auth.getCusec()) {
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_MUT_FAIL);
            }
        }
    }
}

