/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class S3TokenCredential
implements Credential {
    public static final String S3_TOKEN_CREDENTIAL_TYPE = "s3-token";
    public static final String GRAVITINO_S3_SESSION_ACCESS_KEY_ID = "s3-access-key-id";
    public static final String GRAVITINO_S3_SESSION_SECRET_ACCESS_KEY = "s3-secret-access-key";
    public static final String GRAVITINO_S3_TOKEN = "s3-session-token";
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final long expireTimeInMS;

    public S3TokenCredential(String accessKeyId, String secretAccessKey, String sessionToken, long expireTimeInMS) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessKeyId), (Object)"S3 access key Id should not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)secretAccessKey), (Object)"S3 secret access key should not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sessionToken), (Object)"S3 session token should not be empty");
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expireTimeInMS = expireTimeInMS;
    }

    @Override
    public String credentialType() {
        return S3_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMS;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder().put((Object)GRAVITINO_S3_SESSION_ACCESS_KEY_ID, (Object)this.accessKeyId).put((Object)GRAVITINO_S3_SESSION_SECRET_ACCESS_KEY, (Object)this.secretAccessKey).put((Object)GRAVITINO_S3_TOKEN, (Object)this.sessionToken).build();
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }
}

