/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.storage.EntityKeyEncoder;
import org.apache.gravitino.storage.NameMappingService;
import org.apache.gravitino.storage.kv.BinaryEntityEncoderUtil;
import org.apache.gravitino.utils.ByteUtils;
import org.apache.gravitino.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEntityKeyEncoder
implements EntityKeyEncoder<byte[]> {
    public static final Logger LOG = LoggerFactory.getLogger(BinaryEntityKeyEncoder.class);
    public static final String NAMESPACE_SEPARATOR = "/";
    public static final String TYPE_AND_NAME_SEPARATOR = "_";
    @VisibleForTesting
    static final byte[] BYTABLE_NAMESPACE_SEPARATOR = "/".getBytes(StandardCharsets.UTF_8);
    static final String WILD_CARD = "*";
    public static final Map<Entity.EntityType, String[]> ENTITY_TYPE_TO_NAME_IDENTIFIER = ImmutableMap.of((Object)((Object)Entity.EntityType.METALAKE), (Object)new String[]{Entity.EntityType.METALAKE.getShortName() + "/"}, (Object)((Object)Entity.EntityType.CATALOG), (Object)new String[]{Entity.EntityType.CATALOG.getShortName() + "/", "/"}, (Object)((Object)Entity.EntityType.SCHEMA), (Object)new String[]{Entity.EntityType.SCHEMA.getShortName() + "/", "/", "/"}, (Object)((Object)Entity.EntityType.TABLE), (Object)new String[]{Entity.EntityType.TABLE.getShortName() + "/", "/", "/", "/"}, (Object)((Object)Entity.EntityType.FILESET), (Object)new String[]{Entity.EntityType.FILESET.getShortName() + "/", "/", "/", "/"}, (Object)((Object)Entity.EntityType.USER), (Object)new String[]{Entity.EntityType.USER.getShortName() + "/", "/", "/", "/"}, (Object)((Object)Entity.EntityType.GROUP), (Object)new String[]{Entity.EntityType.GROUP.getShortName() + "/", "/", "/", "/"}, (Object)((Object)Entity.EntityType.ROLE), (Object)new String[]{Entity.EntityType.ROLE.getShortName() + "/", "/", "/", "/"}, (Object)((Object)Entity.EntityType.TOPIC), (Object)new String[]{Entity.EntityType.TOPIC.getShortName() + "/", "/", "/", "/"});
    @VisibleForTesting
    final NameMappingService nameMappingService;

    public BinaryEntityKeyEncoder(NameMappingService nameMappingService) {
        this.nameMappingService = nameMappingService;
    }

    private byte[] encodeEntity(NameIdentifier identifier, Entity.EntityType entityType, boolean nullIfMissing) throws IOException {
        String nameKey;
        String[] nameSpace = identifier.namespace().levels();
        long[] namespaceIds = new long[nameSpace.length];
        List<Entity.EntityType> parentEntityTypes = Entity.EntityType.getParentEntityTypes(entityType);
        for (int i = 0; i < nameSpace.length; ++i) {
            nameKey = BinaryEntityEncoderUtil.concatIdAndName(ArrayUtils.subarray((long[])namespaceIds, (int)0, (int)i), nameSpace[i], parentEntityTypes.get(i));
            if (nullIfMissing && null == this.nameMappingService.getIdByName(nameKey)) {
                return null;
            }
            namespaceIds[i] = this.nameMappingService.getOrCreateIdFromName(nameKey);
        }
        if (WILD_CARD.equals(identifier.name())) {
            String[] namespaceTemplate = ENTITY_TYPE_TO_NAME_IDENTIFIER.get((Object)entityType);
            if (namespaceTemplate == null) {
                throw new UnsupportedOperationException("Unsupported entity type: " + (Object)((Object)entityType));
            }
            return this.formatNamespaceTemplateToByte(namespaceTemplate, namespaceIds);
        }
        long[] namespaceAndNameIds = new long[namespaceIds.length + 1];
        System.arraycopy(namespaceIds, 0, namespaceAndNameIds, 0, namespaceIds.length);
        nameKey = BinaryEntityEncoderUtil.concatIdAndName(namespaceIds, identifier.name(), entityType);
        if (nullIfMissing && null == this.nameMappingService.getIdByName(nameKey)) {
            return null;
        }
        namespaceAndNameIds[namespaceIds.length] = this.nameMappingService.getOrCreateIdFromName(nameKey);
        String[] nameIdentifierTemplate = ENTITY_TYPE_TO_NAME_IDENTIFIER.get((Object)entityType);
        if (nameIdentifierTemplate == null) {
            throw new UnsupportedOperationException("Unsupported entity type: " + (Object)((Object)entityType));
        }
        return this.formatNameIdentifierTemplateToByte(nameIdentifierTemplate, namespaceAndNameIds);
    }

    private byte[] formatNamespaceTemplateToByte(String[] namespaceTemplate, long[] ids) {
        Preconditions.checkArgument((namespaceTemplate.length == ids.length + 1 ? 1 : 0) != 0);
        byte[] bytes = new byte[]{};
        for (int i = 0; i < namespaceTemplate.length; ++i) {
            bytes = i != namespaceTemplate.length - 1 ? Bytes.concat(bytes, namespaceTemplate[i].getBytes(StandardCharsets.UTF_8), ByteUtils.longToByte(ids[i])) : Bytes.concat(bytes, namespaceTemplate[i].getBytes(StandardCharsets.UTF_8));
        }
        return bytes;
    }

    private byte[] formatNameIdentifierTemplateToByte(String[] nameIdentifierTemplate, long[] ids) {
        Preconditions.checkArgument((nameIdentifierTemplate.length == ids.length ? 1 : 0) != 0);
        byte[] bytes = new byte[]{};
        for (int i = 0; i < ids.length; ++i) {
            bytes = Bytes.concat(bytes, nameIdentifierTemplate[i].getBytes(StandardCharsets.UTF_8), ByteUtils.longToByte(ids[i]));
        }
        return bytes;
    }

    @Override
    public byte[] encode(NameIdentifier ident, Entity.EntityType type, boolean nullIfMissing) throws IOException {
        return this.encodeEntity(ident, type, nullIfMissing);
    }

    @Override
    public Pair<NameIdentifier, Entity.EntityType> decode(byte[] key) throws IOException {
        String entityTypeString = new String(ArrayUtils.subarray((byte[])key, (int)0, (int)2), StandardCharsets.UTF_8);
        Entity.EntityType entityType = Entity.EntityType.fromShortName(entityTypeString);
        byte[] idArrays = ArrayUtils.subarray((byte[])key, (int)3, (int)key.length);
        long[] ids = new long[(idArrays.length + 1) / 9];
        int index = 0;
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ByteUtils.byteToLong(ArrayUtils.subarray((byte[])idArrays, (int)index, (int)(index + 8)));
            index += 9;
        }
        String[] names = new String[ids.length];
        List<Entity.EntityType> parents = Entity.EntityType.getParentEntityTypes(entityType);
        for (int i = 0; i < ids.length; ++i) {
            String name = this.nameMappingService.getNameById(ids[i]);
            Entity.EntityType currentEntityType = i < parents.size() ? parents.get(i) : entityType;
            names[i] = BinaryEntityEncoderUtil.VERSION_0_4_COMPATIBLE_ENTITY_TYPES.contains((Object)currentEntityType) ? name.split(NAMESPACE_SEPARATOR, i + 1)[i] : name.split(NAMESPACE_SEPARATOR, i + 1)[i].substring(3);
        }
        NameIdentifier nameIdentifier = NameIdentifier.of((String[])names);
        return Pair.of((Object)nameIdentifier, (Object)((Object)entityType));
    }
}

