/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import java.util.Collection;
import java.util.List;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.ProtoSerDe;
import org.apache.gravitino.proto.User;

public class UserEntitySerDe
implements ProtoSerDe<UserEntity, User> {
    @Override
    public User serialize(UserEntity userEntity) {
        User.Builder builder = User.newBuilder().setId(userEntity.id().longValue()).setName(userEntity.name()).setAuditInfo(new AuditInfoSerDe().serialize(userEntity.auditInfo()));
        if (this.isCollectionNotEmpty(userEntity.roles())) {
            builder.addAllRoleNames(userEntity.roles());
        }
        if (this.isCollectionNotEmpty(userEntity.roleIds())) {
            builder.addAllRoleIds(userEntity.roleIds());
        }
        return builder.build();
    }

    @Override
    public UserEntity deserialize(User user, Namespace namespace) {
        UserEntity.Builder builder = UserEntity.builder().withId(user.getId()).withName(user.getName()).withNamespace(namespace).withAuditInfo(new AuditInfoSerDe().deserialize(user.getAuditInfo(), namespace));
        if (user.getRoleNamesCount() > 0) {
            builder.withRoleNames((List<String>)user.getRoleNamesList());
        }
        if (user.getRoleIdsCount() > 0) {
            builder.withRoleIds(user.getRoleIdsList());
        }
        return builder.build();
    }

    private boolean isCollectionNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }
}

