/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.function.Consumer;
import org.apache.gravitino.client.ErrorHandler;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.dto.responses.OAuth2ErrorResponse;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.BadRequestException;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.CatalogNotInUseException;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeInUseException;
import org.apache.gravitino.exceptions.MetalakeNotInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.NonEmptyCatalogException;
import org.apache.gravitino.exceptions.NonEmptyMetalakeException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.NotInUseException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.exceptions.RESTException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;

public class ErrorHandlers {
    public static Consumer<ErrorResponse> metalakeErrorHandler() {
        return MetalakeErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> catalogErrorHandler() {
        return CatalogErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> schemaErrorHandler() {
        return SchemaErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tableErrorHandler() {
        return TableErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> partitionErrorHandler() {
        return PartitionErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> restErrorHandler() {
        return RestErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> oauthErrorHandler() {
        return OAuthErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> filesetErrorHandler() {
        return FilesetErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> topicErrorHandler() {
        return TopicErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> userErrorHandler() {
        return UserErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> groupErrorHandler() {
        return GroupErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> roleErrorHandler() {
        return RoleErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> permissionOperationErrorHandler() {
        return PermissionOperationErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tagErrorHandler() {
        return TagErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> ownerErrorHandler() {
        return OwnerErrorHandler.INSTANCE;
    }

    private ErrorHandlers() {
    }

    private static String getStackString(List<String> stack) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        Joiner eol = Joiner.on((String)"\n");
        return eol.join(stack);
    }

    private static String formatErrorMessage(ErrorResponse errorResponse) {
        String message = errorResponse.getMessage();
        String stack = ErrorHandlers.getStackString(errorResponse.getStack());
        if (stack.isEmpty()) {
            return message;
        }
        return String.format("%s%n%s", message, stack);
    }

    private static class RestErrorHandler
    extends ErrorHandler {
        private static final ErrorHandler INSTANCE = new RestErrorHandler();

        private RestErrorHandler() {
        }

        @Override
        public ErrorResponse parseResponse(int code, String json, ObjectMapper mapper) {
            try {
                return (ErrorResponse)mapper.readValue(json, ErrorResponse.class);
            }
            catch (Exception e) {
                String errorMsg = String.format("Error code: %d, error message: %s, json string: %s", code, e.getMessage(), json);
                return ErrorResponse.unknownError((String)errorMsg);
            }
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            throw new RESTException("Unable to process: %s", new Object[]{ErrorHandlers.formatErrorMessage(errorResponse)});
        }
    }

    private static class OwnerErrorHandler
    extends RestErrorHandler {
        private static final OwnerErrorHandler INSTANCE = new OwnerErrorHandler();

        private OwnerErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TagErrorHandler
    extends RestErrorHandler {
        private static final TagErrorHandler INSTANCE = new TagErrorHandler();

        private TagErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTagException.class.getSimpleName())) {
                        throw new NoSuchTagException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    if (errorResponse.getType().equals(TagAlreadyExistsException.class.getSimpleName())) {
                        throw new TagAlreadyExistsException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(TagAlreadyAssociatedException.class.getSimpleName())) {
                        throw new TagAlreadyAssociatedException(errorMessage, new Object[0]);
                    }
                    throw new AlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class PermissionOperationErrorHandler
    extends RestErrorHandler {
        private static final PermissionOperationErrorHandler INSTANCE = new PermissionOperationErrorHandler();

        private PermissionOperationErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    if (errorResponse.getType().equals(IllegalPrivilegeException.class.getSimpleName())) {
                        throw new IllegalPrivilegeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(IllegalRoleException.class.getSimpleName())) {
                        throw new IllegalRoleException(errorMessage, new Object[0]);
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchUserException.class.getSimpleName())) {
                        throw new NoSuchUserException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchGroupException.class.getSimpleName())) {
                        throw new NoSuchGroupException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchRoleException.class.getSimpleName())) {
                        throw new NoSuchRoleException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class RoleErrorHandler
    extends RestErrorHandler {
        private static final RoleErrorHandler INSTANCE = new RoleErrorHandler();

        private RoleErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    if (errorResponse.getType().equals(IllegalPrivilegeException.class.getSimpleName())) {
                        throw new IllegalPrivilegeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(IllegalMetadataObjectException.class.getSimpleName())) {
                        throw new IllegalMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchRoleException.class.getSimpleName())) {
                        throw new NoSuchRoleException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new RoleAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class GroupErrorHandler
    extends RestErrorHandler {
        private static final GroupErrorHandler INSTANCE = new GroupErrorHandler();

        private GroupErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchGroupException.class.getSimpleName())) {
                        throw new NoSuchGroupException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new GroupAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class UserErrorHandler
    extends RestErrorHandler {
        private static final UserErrorHandler INSTANCE = new UserErrorHandler();

        private UserErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchUserException.class.getSimpleName())) {
                        throw new NoSuchUserException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new UserAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TopicErrorHandler
    extends RestErrorHandler {
        private static final TopicErrorHandler INSTANCE = new TopicErrorHandler();

        private TopicErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTopicException.class.getSimpleName())) {
                        throw new NoSuchTopicException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new TopicAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class FilesetErrorHandler
    extends RestErrorHandler {
        private static final FilesetErrorHandler INSTANCE = new FilesetErrorHandler();

        private FilesetErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchFilesetException.class.getSimpleName())) {
                        throw new NoSuchFilesetException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new FilesetAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    public static class OAuthErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new OAuthErrorHandler();

        @Override
        public ErrorResponse parseResponse(int code, String json, ObjectMapper mapper) {
            try {
                OAuth2ErrorResponse response = (OAuth2ErrorResponse)mapper.readValue(json, OAuth2ErrorResponse.class);
                return ErrorResponse.oauthError((int)code, (String)response.getType(), (String)response.getMessage());
            }
            catch (Exception e) {
                String errorMsg = String.format("Error code: %d, error message: %s, json string: %s", code, e.getMessage(), json);
                return ErrorResponse.unknownError((String)errorMsg);
            }
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            if (errorResponse.getType() != null) {
                switch (errorResponse.getType()) {
                    case "invalid_client": {
                        throw new UnauthorizedException("Not authorized: %s: %s", new Object[]{errorResponse.getType(), errorResponse.getMessage()});
                    }
                    case "invalid_request": 
                    case "invalid_grant": 
                    case "unauthorized_client": 
                    case "unsupported_grant_type": 
                    case "invalid_scope": {
                        throw new BadRequestException("Malformed request: %s: %s", new Object[]{errorResponse.getType(), errorResponse.getMessage()});
                    }
                }
                super.accept(errorResponse);
            }
            super.accept(errorResponse);
        }
    }

    private static class MetalakeErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new MetalakeErrorHandler();

        private MetalakeErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new MetalakeAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1010: {
                    throw new MetalakeInUseException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptyMetalakeException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class CatalogErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new CatalogErrorHandler();

        private CatalogErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1007: {
                    throw new ConnectionFailedException(errorMessage, new Object[0]);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchCatalogException.class.getSimpleName())) {
                        throw new NoSuchCatalogException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new CatalogAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1010: {
                    if (errorResponse.getType().equals(CatalogInUseException.class.getSimpleName())) {
                        throw new CatalogInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeInUseException.class.getSimpleName())) {
                        throw new MetalakeInUseException(errorMessage, new Object[0]);
                    }
                    throw new InUseException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptyCatalogException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class SchemaErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new SchemaErrorHandler();

        private SchemaErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchCatalogException.class.getSimpleName())) {
                        throw new NoSuchCatalogException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new SchemaAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptySchemaException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TableErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new TableErrorHandler();

        private TableErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTableException.class.getSimpleName())) {
                        throw new NoSuchTableException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new TableAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class PartitionErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new PartitionErrorHandler();

        private PartitionErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTableException.class.getSimpleName())) {
                        throw new NoSuchTableException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchPartitionException.class.getSimpleName())) {
                        throw new NoSuchPartitionException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new PartitionAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }
}

