/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class Pair<X, Y>
implements IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final LoadingCache<Pair<Class<?>, Class<?>>, Schema> SCHEMA_CACHE = Caffeine.newBuilder().build(new CacheLoader<Pair<Class<?>, Class<?>>, Schema>(){

        public Schema load(Pair<Class<?>, Class<?>> key) {
            Schema xSchema = ReflectData.get().getSchema((Type)((Pair)key).first);
            Schema ySchema = ReflectData.get().getSchema((Type)((Pair)key).second);
            return Schema.createRecord((String)"pair", null, null, (boolean)false, (List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("x", xSchema, null, null), new Schema.Field("y", ySchema, null, null)}));
        }
    });
    private Schema schema = null;
    private X first;
    private Y second;

    public static <X, Y> Pair<X, Y> of(X first, Y second) {
        return new Pair<X, Y>(first, second);
    }

    private Pair(Schema schema) {
        this.schema = schema;
    }

    private Pair(X first, Y second) {
        this.first = first;
        this.second = second;
    }

    public void put(int i, Object v) {
        if (i == 0) {
            this.first = v;
            return;
        }
        if (i == 1) {
            this.second = v;
            return;
        }
        throw new IllegalArgumentException("Cannot set value " + i + " (not 0 or 1): " + v);
    }

    public Object get(int i) {
        if (i == 0) {
            return this.first;
        }
        if (i == 1) {
            return this.second;
        }
        throw new IllegalArgumentException("Cannot get value " + i + " (not 0 or 1)");
    }

    public Schema getSchema() {
        if (this.schema == null) {
            this.schema = (Schema)SCHEMA_CACHE.get(Pair.of(this.first.getClass(), this.second.getClass()));
        }
        return this.schema;
    }

    public X first() {
        return this.first;
    }

    public Y second() {
        return this.second;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair otherPair = (Pair)other;
        return Objects.equal(this.first, otherPair.first) && Objects.equal(this.second, otherPair.second);
    }
}

