/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class GenericAvroWriter<T>
implements MetricsAwareDatumWriter<T> {
    private ValueWriter<T> writer = null;

    public static <D> GenericAvroWriter<D> create(Schema schema) {
        return new GenericAvroWriter(schema);
    }

    GenericAvroWriter(Schema schema) {
        this.setSchema(schema);
    }

    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroSchemaVisitor.visit(schema, new WriteBuilder());
    }

    public void write(T datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    @Override
    public Stream<FieldMetrics> metrics() {
        return this.writer.metrics();
    }

    private static class WriteBuilder
    extends AvroSchemaVisitor<ValueWriter<?>> {
        private WriteBuilder() {
        }

        @Override
        public ValueWriter<?> record(Schema record, List<String> names, List<ValueWriter<?>> fields) {
            return ValueWriters.record(fields);
        }

        @Override
        public ValueWriter<?> union(Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument((boolean)options.contains(ValueWriters.nulls()), (String)"Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument((options.size() == 2 ? 1 : 0) != 0, (String)"Cannot create writer for non-option union: %s", (Object)union);
            if (((Schema)union.getTypes().get(0)).getType() == Schema.Type.NULL) {
                return ValueWriters.option(0, options.get(1));
            }
            return ValueWriters.option(1, options.get(0));
        }

        @Override
        public ValueWriter<?> array(Schema array, ValueWriter<?> elementWriter) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueWriters.StructWriter keyValueWriter = (ValueWriters.StructWriter)elementWriter;
                return ValueWriters.arrayMap(keyValueWriter.writer(0), keyValueWriter.writer(1));
            }
            return ValueWriters.array(elementWriter);
        }

        @Override
        public ValueWriter<?> map(Schema map, ValueWriter<?> valueWriter) {
            return ValueWriters.map(ValueWriters.strings(), valueWriter);
        }

        @Override
        public ValueWriter<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueWriters.ints();
                    }
                    case "time-micros": {
                        return ValueWriters.longs();
                    }
                    case "timestamp-micros": {
                        return ValueWriters.longs();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueWriters.decimal(decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return ValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return ValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.genericFixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

