/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import org.apache.gravitino.dto.authorization.GroupDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class GroupResponse
extends BaseResponse {
    @JsonProperty(value="group")
    private final GroupDTO group;

    public GroupResponse(GroupDTO group) {
        super(0);
        this.group = group;
    }

    public GroupResponse() {
        this.group = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.group != null, "group must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.group.name()), "group 'name' must not be null and empty");
        Preconditions.checkArgument(this.group.auditInfo() != null, "group 'auditInfo' must not be null");
    }

    public GroupDTO getGroup() {
        return this.group;
    }

    @Override
    public String toString() {
        return "GroupResponse(group=" + this.getGroup() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupResponse)) {
            return false;
        }
        GroupResponse other = (GroupResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupDTO this$group = this.getGroup();
        GroupDTO other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GroupResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GroupDTO $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }
}

