/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class BlobMetadata {
    private final String type;
    private final List<Integer> inputFields;
    private final long snapshotId;
    private final long sequenceNumber;
    private final long offset;
    private final long length;
    private final String compressionCodec;
    private final Map<String, String> properties;

    public BlobMetadata(String type, List<Integer> inputFields, long snapshotId, long sequenceNumber, long offset, long length, @Nullable String compressionCodec, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(inputFields, (Object)"inputFields is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.type = type;
        this.inputFields = ImmutableList.copyOf(inputFields);
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.offset = offset;
        this.length = length;
        this.compressionCodec = compressionCodec;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public String type() {
        return this.type;
    }

    public List<Integer> inputFields() {
        return this.inputFields;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    @Nullable
    public String compressionCodec() {
        return this.compressionCodec;
    }

    public Map<String, String> properties() {
        return this.properties;
    }
}

