/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseEntriesTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class ManifestEntriesTable
extends BaseEntriesTable {
    ManifestEntriesTable(Table table) {
        this(table, table.name() + ".entries");
    }

    ManifestEntriesTable(Table table, String name) {
        super(table, name);
    }

    public TableScan newScan() {
        return new EntriesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ENTRIES;
    }

    private static class EntriesTableScan
    extends BaseMetadataTableScan {
        EntriesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.ENTRIES);
        }

        private EntriesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.ENTRIES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new EntriesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            CloseableIterable manifests = CloseableIterable.withNoopClose((Iterable)this.snapshot().allManifests(this.table().io()));
            return BaseEntriesTable.planFiles(this.table(), (CloseableIterable<ManifestFile>)manifests, this.tableSchema(), this.schema(), this.context());
        }
    }
}

