/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
public class DelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(DelegationTokenSecretManager.class);
    private final FSNamesystem namesystem;
    private final SerializerCompat serializerCompat = new SerializerCompat();

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
        this(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, false, namesystem);
    }

    public DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, boolean storeTokenTrackingId, FSNamesystem namesystem) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.namesystem = namesystem;
        this.storeTokenTrackingId = storeTokenTrackingId;
    }

    public DelegationTokenIdentifier createIdentifier() {
        return new DelegationTokenIdentifier();
    }

    public byte[] retrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken {
        try {
            this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        }
        catch (StandbyException se) {
            SecretManager.InvalidToken wrappedStandby = new SecretManager.InvalidToken("StandbyException");
            wrappedStandby.initCause((Throwable)se);
            throw wrappedStandby;
        }
        return super.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
    }

    public byte[] retriableRetrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken, StandbyException, RetriableException, IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        try {
            return super.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.namesystem.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    public synchronized long getTokenExpiryTime(DelegationTokenIdentifier dtId) throws IOException {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(dtId);
        if (info != null) {
            return info.getRenewDate();
        }
        throw new IOException("No delegation token found for this identifier");
    }

    public synchronized void loadSecretManagerStateCompat(DataInput in) throws IOException {
        if (this.running) {
            throw new IOException("Can't load state from image in a running SecretManager.");
        }
        this.serializerCompat.load(in);
    }

    public synchronized void loadSecretManagerState(SecretManagerState state) throws IOException {
        Preconditions.checkState((!this.running ? 1 : 0) != 0, (Object)"Can't load state from image in a running SecretManager.");
        this.currentId = state.section.getCurrentId();
        this.delegationTokenSequenceNumber = state.section.getTokenSequenceNumber();
        for (FsImageProto.SecretManagerSection.DelegationKey k : state.keys) {
            this.addKey(new DelegationKey(k.getId(), k.getExpiryDate(), k.hasKey() ? k.getKey().toByteArray() : null));
        }
        for (FsImageProto.SecretManagerSection.PersistToken t : state.tokens) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier(new Text(t.getOwner()), new Text(t.getRenewer()), new Text(t.getRealUser()));
            id.setIssueDate(t.getIssueDate());
            id.setMaxDate(t.getMaxDate());
            id.setSequenceNumber(t.getSequenceNumber());
            id.setMasterKeyId(t.getMasterKeyId());
            this.addPersistedDelegationToken(id, t.getExpiryDate());
        }
    }

    public synchronized void saveSecretManagerStateCompat(DataOutputStream out, String sdPath) throws IOException {
        this.serializerCompat.save(out, sdPath);
    }

    public synchronized SecretManagerState saveSecretManagerState() {
        FsImageProto.SecretManagerSection s = FsImageProto.SecretManagerSection.newBuilder().setCurrentId(this.currentId).setTokenSequenceNumber(this.delegationTokenSequenceNumber).setNumKeys(this.allKeys.size()).setNumTokens(this.currentTokens.size()).build();
        ArrayList keys = Lists.newArrayListWithCapacity((int)this.allKeys.size());
        ArrayList tokens = Lists.newArrayListWithCapacity((int)this.currentTokens.size());
        for (DelegationKey delegationKey : this.allKeys.values()) {
            FsImageProto.SecretManagerSection.DelegationKey.Builder b = FsImageProto.SecretManagerSection.DelegationKey.newBuilder().setId(delegationKey.getKeyId()).setExpiryDate(delegationKey.getExpiryDate());
            if (delegationKey.getEncodedKey() != null) {
                b.setKey(ByteString.copyFrom((byte[])delegationKey.getEncodedKey()));
            }
            keys.add(b.build());
        }
        for (Map.Entry entry : this.currentTokens.entrySet()) {
            DelegationTokenIdentifier id = (DelegationTokenIdentifier)entry.getKey();
            FsImageProto.SecretManagerSection.PersistToken.Builder b = FsImageProto.SecretManagerSection.PersistToken.newBuilder().setOwner(id.getOwner().toString()).setRenewer(id.getRenewer().toString()).setRealUser(id.getRealUser().toString()).setIssueDate(id.getIssueDate()).setMaxDate(id.getMaxDate()).setSequenceNumber(id.getSequenceNumber()).setMasterKeyId(id.getMasterKeyId()).setExpiryDate(((AbstractDelegationTokenSecretManager.DelegationTokenInformation)entry.getValue()).getRenewDate());
            tokens.add(b.build());
        }
        return new SecretManagerState(s, keys, tokens);
    }

    public synchronized void addPersistedDelegationToken(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't add persisted delegation token to a running SecretManager.");
        }
        int keyId = identifier.getMasterKeyId();
        DelegationKey dKey = (DelegationKey)this.allKeys.get(keyId);
        if (dKey == null) {
            LOG.warn((Object)("No KEY found for persisted identifier " + identifier.toString()));
            return;
        }
        byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)dKey.getKey());
        if (identifier.getSequenceNumber() > this.delegationTokenSequenceNumber) {
            this.delegationTokenSequenceNumber = identifier.getSequenceNumber();
        }
        if (this.currentTokens.get(identifier) != null) {
            throw new IOException("Same delegation token being added twice; invalid entry in fsimage or editlogs");
        }
        this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled((AbstractDelegationTokenIdentifier)identifier)));
    }

    public synchronized void updatePersistedMasterKey(DelegationKey key) throws IOException {
        this.addKey(key);
    }

    public synchronized void updatePersistedTokenRenewal(DelegationTokenIdentifier identifier, long expiryTime) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = null;
        info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(identifier);
        if (info != null) {
            int keyId = identifier.getMasterKeyId();
            byte[] password = DelegationTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)((DelegationKey)this.allKeys.get(keyId)).getKey());
            this.currentTokens.put(identifier, new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expiryTime, password, this.getTrackingIdIfEnabled((AbstractDelegationTokenIdentifier)identifier)));
        }
    }

    public synchronized void updatePersistedTokenCancellation(DelegationTokenIdentifier identifier) throws IOException {
        if (this.running) {
            throw new IOException("Can't update persisted delegation token renewal to a running SecretManager.");
        }
        this.currentTokens.remove(identifier);
    }

    public synchronized int getNumberOfKeys() {
        return this.allKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
        try {
            this.namesystem.readLockInterruptibly();
            try {
                Object object = this.noInterruptsLock;
                synchronized (object) {
                    block10: {
                        if (!Thread.currentThread().isInterrupted()) break block10;
                        return;
                    }
                    this.namesystem.logUpdateMasterKey(key);
                }
            }
            finally {
                this.namesystem.readUnlock();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logExpireToken(DelegationTokenIdentifier dtId) throws IOException {
        try {
            this.namesystem.readLockInterruptibly();
            try {
                Object object = this.noInterruptsLock;
                synchronized (object) {
                    block10: {
                        if (!Thread.currentThread().isInterrupted()) break block10;
                        return;
                    }
                    this.namesystem.logExpireDelegationToken(dtId);
                }
            }
            finally {
                this.namesystem.readUnlock();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static Credentials createCredentials(NameNode namenode, UserGroupInformation ugi, String renewer) throws IOException {
        Token token = namenode.getRpcServer().getDelegationToken(new Text(renewer));
        if (token == null) {
            return null;
        }
        InetSocketAddress addr = namenode.getNameNodeAddress();
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        Credentials c = new Credentials();
        c.addToken(new Text(ugi.getShortUserName()), token);
        return c;
    }

    private final class SerializerCompat {
        private SerializerCompat() {
        }

        private void load(DataInput in) throws IOException {
            DelegationTokenSecretManager.this.currentId = in.readInt();
            this.loadAllKeys(in);
            DelegationTokenSecretManager.this.delegationTokenSequenceNumber = in.readInt();
            this.loadCurrentTokens(in);
        }

        private void save(DataOutputStream out, String sdPath) throws IOException {
            out.writeInt(DelegationTokenSecretManager.this.currentId);
            this.saveAllKeys(out, sdPath);
            out.writeInt(DelegationTokenSecretManager.this.delegationTokenSequenceNumber);
            this.saveCurrentTokens(out, sdPath);
        }

        private synchronized void saveCurrentTokens(DataOutputStream out, String sdPath) throws IOException {
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.DELEGATION_TOKENS, sdPath);
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            prog.setTotal(Phase.SAVING_CHECKPOINT, step, DelegationTokenSecretManager.this.currentTokens.size());
            StartupProgress.Counter counter = prog.getCounter(Phase.SAVING_CHECKPOINT, step);
            out.writeInt(DelegationTokenSecretManager.this.currentTokens.size());
            for (DelegationTokenIdentifier id : DelegationTokenSecretManager.this.currentTokens.keySet()) {
                id.write((DataOutput)out);
                AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)DelegationTokenSecretManager.this.currentTokens.get(id);
                out.writeLong(info.getRenewDate());
                counter.increment();
            }
            prog.endStep(Phase.SAVING_CHECKPOINT, step);
        }

        private synchronized void saveAllKeys(DataOutputStream out, String sdPath) throws IOException {
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.DELEGATION_KEYS, sdPath);
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            prog.setTotal(Phase.SAVING_CHECKPOINT, step, DelegationTokenSecretManager.this.currentTokens.size());
            StartupProgress.Counter counter = prog.getCounter(Phase.SAVING_CHECKPOINT, step);
            out.writeInt(DelegationTokenSecretManager.this.allKeys.size());
            for (Integer key : DelegationTokenSecretManager.this.allKeys.keySet()) {
                ((DelegationKey)DelegationTokenSecretManager.this.allKeys.get(key)).write((DataOutput)out);
                counter.increment();
            }
            prog.endStep(Phase.SAVING_CHECKPOINT, step);
        }

        private synchronized void loadCurrentTokens(DataInput in) throws IOException {
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.DELEGATION_TOKENS);
            prog.beginStep(Phase.LOADING_FSIMAGE, step);
            int numberOfTokens = in.readInt();
            prog.setTotal(Phase.LOADING_FSIMAGE, step, numberOfTokens);
            StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
            for (int i = 0; i < numberOfTokens; ++i) {
                DelegationTokenIdentifier id = new DelegationTokenIdentifier();
                id.readFields(in);
                long expiryTime = in.readLong();
                DelegationTokenSecretManager.this.addPersistedDelegationToken(id, expiryTime);
                counter.increment();
            }
            prog.endStep(Phase.LOADING_FSIMAGE, step);
        }

        private synchronized void loadAllKeys(DataInput in) throws IOException {
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.DELEGATION_KEYS);
            prog.beginStep(Phase.LOADING_FSIMAGE, step);
            int numberOfKeys = in.readInt();
            prog.setTotal(Phase.LOADING_FSIMAGE, step, numberOfKeys);
            StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
            for (int i = 0; i < numberOfKeys; ++i) {
                DelegationKey value = new DelegationKey();
                value.readFields(in);
                DelegationTokenSecretManager.this.addKey(value);
                counter.increment();
            }
            prog.endStep(Phase.LOADING_FSIMAGE, step);
        }
    }

    public static class SecretManagerState {
        public final FsImageProto.SecretManagerSection section;
        public final List<FsImageProto.SecretManagerSection.DelegationKey> keys;
        public final List<FsImageProto.SecretManagerSection.PersistToken> tokens;

        public SecretManagerState(FsImageProto.SecretManagerSection s, List<FsImageProto.SecretManagerSection.DelegationKey> keys, List<FsImageProto.SecretManagerSection.PersistToken> tokens) {
            this.section = s;
            this.keys = keys;
            this.tokens = tokens;
        }
    }
}

