/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.iceberg.common.ClosableHiveCatalog;
import org.apache.gravitino.iceberg.common.IcebergCatalogBackend;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.authentication.AuthenticationConfig;
import org.apache.gravitino.iceberg.common.authentication.kerberos.HiveBackendProxy;
import org.apache.gravitino.iceberg.common.authentication.kerberos.KerberosClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.inmemory.InMemoryCatalog;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.rest.RESTCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogUtil.class);

    private static InMemoryCatalog loadMemoryCatalog(IcebergConfig icebergConfig) {
        String icebergCatalogName = icebergConfig.getCatalogBackendName("memory");
        InMemoryCatalog memoryCatalog = new InMemoryCatalog();
        Map<String, String> resultProperties = icebergConfig.getIcebergCatalogProperties();
        resultProperties.put("warehouse", "/tmp");
        memoryCatalog.initialize(icebergCatalogName, resultProperties);
        return memoryCatalog;
    }

    private static HiveCatalog loadHiveCatalog(IcebergConfig icebergConfig) {
        ClosableHiveCatalog hiveCatalog = new ClosableHiveCatalog();
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        String icebergCatalogName = icebergConfig.getCatalogBackendName("hive");
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        AuthenticationConfig authenticationConfig = new AuthenticationConfig(properties);
        if (authenticationConfig.isSimpleAuth()) {
            hiveCatalog.setConf((Configuration)hdfsConfiguration);
            hiveCatalog.initialize(icebergCatalogName, properties);
            return hiveCatalog;
        }
        if (authenticationConfig.isKerberosAuth()) {
            HashMap<String, String> resultProperties = new HashMap<String, String>(properties);
            resultProperties.put("client-pool-cache-keys", "USER_NAME");
            hdfsConfiguration.set("hadoop.security.authorization", "true");
            hdfsConfiguration.set("hadoop.security.authentication", "kerberos");
            hiveCatalog.setConf((Configuration)hdfsConfiguration);
            hiveCatalog.initialize(icebergCatalogName, properties);
            KerberosClient kerberosClient = IcebergCatalogUtil.initKerberosAndReturnClient(properties, (Configuration)hdfsConfiguration);
            hiveCatalog.addResource(kerberosClient);
            if (authenticationConfig.isImpersonationEnabled()) {
                HiveBackendProxy proxyHiveCatalog = new HiveBackendProxy(resultProperties, hiveCatalog, kerberosClient.getRealm());
                return proxyHiveCatalog.getProxy();
            }
            return hiveCatalog;
        }
        throw new UnsupportedOperationException("Unsupported authentication method: " + authenticationConfig.getAuthType());
    }

    private static KerberosClient initKerberosAndReturnClient(Map<String, String> properties, Configuration conf) {
        try {
            KerberosClient kerberosClient = new KerberosClient(properties, conf);
            File keytabFile = kerberosClient.saveKeyTabFileFromUri(Long.valueOf(properties.get("catalog_uuid")));
            kerberosClient.login(keytabFile.getAbsolutePath());
            return kerberosClient;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login with kerberos", e);
        }
    }

    private static JdbcCatalog loadJdbcCatalog(IcebergConfig icebergConfig) {
        String driverClassName = icebergConfig.getJdbcDriver();
        String icebergCatalogName = icebergConfig.getCatalogBackendName("jdbc");
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        Preconditions.checkNotNull((Object)properties.get("jdbc.user"), (Object)"jdbc.user is null");
        Preconditions.checkNotNull((Object)properties.get("jdbc.password"), (Object)"jdbc.password is null");
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't load jdbc driver " + driverClassName);
        }
        JdbcCatalog jdbcCatalog = new JdbcCatalog(null, null, ((Boolean)icebergConfig.get(IcebergConfig.JDBC_INIT_TABLES)).booleanValue());
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        jdbcCatalog.setConf((Object)hdfsConfiguration);
        jdbcCatalog.initialize(icebergCatalogName, properties);
        return jdbcCatalog;
    }

    private static Catalog loadRestCatalog(IcebergConfig icebergConfig) {
        String icebergCatalogName = icebergConfig.getCatalogBackendName("rest");
        RESTCatalog restCatalog = new RESTCatalog();
        HdfsConfiguration hdfsConfiguration = new HdfsConfiguration();
        Map<String, String> properties = icebergConfig.getIcebergCatalogProperties();
        properties.forEach((arg_0, arg_1) -> ((HdfsConfiguration)hdfsConfiguration).set(arg_0, arg_1));
        restCatalog.setConf((Object)hdfsConfiguration);
        restCatalog.initialize(icebergCatalogName, properties);
        return restCatalog;
    }

    @VisibleForTesting
    static Catalog loadCatalogBackend(String catalogType) {
        return IcebergCatalogUtil.loadCatalogBackend(IcebergCatalogBackend.valueOf(catalogType.toUpperCase(Locale.ROOT)), new IcebergConfig(Collections.emptyMap()));
    }

    public static Catalog loadCatalogBackend(IcebergCatalogBackend catalogBackend, IcebergConfig icebergConfig) {
        LOG.info("Load catalog backend of {}", (Object)catalogBackend);
        switch (catalogBackend) {
            case MEMORY: {
                return IcebergCatalogUtil.loadMemoryCatalog(icebergConfig);
            }
            case HIVE: {
                return IcebergCatalogUtil.loadHiveCatalog(icebergConfig);
            }
            case JDBC: {
                return IcebergCatalogUtil.loadJdbcCatalog(icebergConfig);
            }
            case REST: {
                return IcebergCatalogUtil.loadRestCatalog(icebergConfig);
            }
        }
        throw new RuntimeException((Object)((Object)catalogBackend) + " catalog is not supported yet, supported catalogs: [memory]" + (Object)((Object)catalogBackend));
    }

    private IcebergCatalogUtil() {
    }
}

