/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metrics.source;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.GravitinoEnv;

public abstract class MetricsSource {
    public static final String ICEBERG_REST_SERVER_METRIC_NAME = "iceberg-rest-server";
    public static final String GRAVITINO_SERVER_METRIC_NAME = "gravitino-server";
    public static final String JVM_METRIC_NAME = "jvm";
    private final MetricRegistry metricRegistry;
    private final String metricsSourceName;
    private final int timeSlidingWindowSeconds;

    protected MetricsSource(String name) {
        this.metricsSourceName = name;
        this.metricRegistry = new MetricRegistry();
        Config config = GravitinoEnv.getInstance().config();
        this.timeSlidingWindowSeconds = config != null ? config.get(Configs.METRICS_TIME_SLIDING_WINDOW_SECONDS) : 60;
    }

    public String getMetricsSourceName() {
        return this.metricsSourceName;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void registerGauge(String name, Gauge gauge) {
        this.metricRegistry.registerGauge(name, gauge);
    }

    public Counter getCounter(String name) {
        return this.metricRegistry.counter(name);
    }

    public Histogram getHistogram(String name) {
        return this.metricRegistry.histogram(name, () -> new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir((long)this.getTimeSlidingWindowSeconds(), TimeUnit.SECONDS)));
    }

    public Timer getTimer(String name) {
        return this.metricRegistry.timer(name, () -> new Timer((Reservoir)new SlidingTimeWindowArrayReservoir((long)this.getTimeSlidingWindowSeconds(), TimeUnit.SECONDS)));
    }

    protected int getTimeSlidingWindowSeconds() {
        return this.timeSlidingWindowSeconds;
    }
}

