/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.AuditInfo;

public class FilesetEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the fileset entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the fileset entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the fileset entity.");
    public static final Field TYPE = Field.required("type", Fileset.Type.class, "The type of the fileset entity.");
    public static final Field STORAGE_LOCATION = Field.required("storage_location", String.class, "The storage location of the fileset entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the fileset entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the fileset entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private Fileset.Type type;
    private String storageLocation;
    private AuditInfo auditInfo;
    private Map<String, String> properties;

    private FilesetEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(TYPE, this.type);
        fields.put(STORAGE_LOCATION, this.storageLocation);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(PROPERTIES, this.properties);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public Long id() {
        return this.id;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.FILESET;
    }

    public String comment() {
        return this.comment;
    }

    public Fileset.Type filesetType() {
        return this.type;
    }

    public String storageLocation() {
        return this.storageLocation;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesetEntity)) {
            return false;
        }
        FilesetEntity that = (FilesetEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.comment, that.comment) && Objects.equals(this.type, that.type) && Objects.equals(this.storageLocation, that.storageLocation) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.comment, this.type, this.storageLocation, this.auditInfo, this.properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FilesetEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + this.namespace + ", comment=" + this.comment + ", type=" + this.type + ", storageLocation=" + this.storageLocation + ", auditInfo=" + this.auditInfo + ", properties=" + this.properties + ")";
    }

    public static class Builder {
        private final FilesetEntity fileset = new FilesetEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.fileset.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.fileset.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.fileset.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.fileset.comment = comment;
            return this;
        }

        public Builder withFilesetType(Fileset.Type type) {
            this.fileset.type = type;
            return this;
        }

        public Builder withStorageLocation(String storageLocation) {
            this.fileset.storageLocation = storageLocation;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.fileset.auditInfo = auditInfo;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.fileset.properties = properties;
            return this;
        }

        public FilesetEntity build() {
            this.fileset.validate();
            return this.fileset;
        }
    }
}

