/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.persister;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.StringType;
import java.sql.SQLException;
import java.util.Date;
import mil.nga.geopackage.db.DateConverter;

public class DatePersister
extends StringType {
    private static final DatePersister singleTon = new DatePersister();
    private static final DateConverter dateConverter = DateConverter.dateTimeConverter();

    private DatePersister() {
        super(SqlType.STRING, new Class[]{Date.class});
    }

    public static DatePersister getSingleton() {
        return singleTon;
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        Object defaultValue = null;
        if ("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".equals(defaultStr)) {
            defaultValue = this.javaToSqlArg(null, new Date());
        }
        return defaultValue;
    }

    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        String stringDate = null;
        if (javaObject != null && javaObject instanceof Date) {
            stringDate = dateConverter.stringValue((Date)javaObject);
        }
        return stringDate;
    }

    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        Date javaDate = null;
        if (sqlArg != null && sqlArg instanceof String) {
            try {
                javaDate = dateConverter.dateValue((String)sqlArg);
            }
            catch (Exception e) {
                throw new SQLException("Failed to parse date string: " + sqlArg, e);
            }
        }
        return javaDate;
    }
}

