/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.List;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.sf.GeometryType;

public class FeatureColumns
extends UserColumns<FeatureColumn> {
    private String geometryColumn;
    private int geometryIndex = -1;

    public FeatureColumns(String tableName, String geometryColumn, List<FeatureColumn> columns) {
        this(tableName, geometryColumn, columns, false);
    }

    public FeatureColumns(String tableName, String geometryColumn, List<FeatureColumn> columns, boolean custom) {
        super(tableName, columns, custom);
        this.geometryColumn = geometryColumn;
        this.updateColumns();
    }

    public FeatureColumns(FeatureColumns featureColumns) {
        super(featureColumns);
        this.geometryColumn = featureColumns.geometryColumn;
        this.geometryIndex = featureColumns.geometryIndex;
    }

    public FeatureColumns copy() {
        return new FeatureColumns(this);
    }

    @Override
    protected void updateColumns() {
        super.updateColumns();
        Integer index = null;
        if (this.geometryColumn != null) {
            index = this.getColumnIndex(this.geometryColumn, false);
        } else {
            for (FeatureColumn column : this.getColumns()) {
                if (!column.isGeometry()) continue;
                index = column.getIndex();
                this.geometryColumn = column.getName();
                break;
            }
        }
        if (!this.isCustom()) {
            this.missingCheck(index, GeometryType.GEOMETRY.name());
        }
        if (index != null) {
            this.geometryIndex = index;
        }
    }

    public String getGeometryColumnName() {
        return this.geometryColumn;
    }

    public void setGeometryColumnName(String geometryColumn) {
        this.geometryColumn = geometryColumn;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public void setGeometryIndex(int geometryIndex) {
        this.geometryIndex = geometryIndex;
    }

    public boolean hasGeometryColumn() {
        return this.geometryIndex >= 0;
    }

    public FeatureColumn getGeometryColumn() {
        FeatureColumn column = null;
        if (this.hasGeometryColumn()) {
            column = (FeatureColumn)this.getColumn(this.geometryIndex);
        }
        return column;
    }
}

