/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterType;

public abstract class GeoPackageDao<T, ID>
extends BaseDaoImpl<T, ID> {
    protected GeoPackageCoreConnection db;

    public GeoPackageDao(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public boolean isTableExists() throws SQLException {
        return super.isTableExists() || this.isView();
    }

    public boolean isTableOrView() {
        return this.isTable() || this.isView();
    }

    public boolean isTable() {
        boolean table;
        try {
            table = super.isTableExists();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to determine if a table: " + this.getTableName(), e);
        }
        return table;
    }

    public boolean isView() {
        return SQLiteMaster.count(this.db, SQLiteMasterType.VIEW, this.getTableName()) > 0;
    }

    public void verifyExists() {
        if (!this.isTableOrView()) {
            throw new GeoPackageException("Table or view does not exist for: " + this.getDataClass().getSimpleName());
        }
    }

    public void setDatabase(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public GeoPackageCoreConnection getDatabase() {
        return this.db;
    }

    public void dropTable(String table) {
        CoreSQLUtils.dropTable(this.db, table);
    }

    public boolean tableExists(String tableName) {
        return this.db.tableExists(tableName);
    }

    public boolean viewExists(String viewName) {
        return this.db.viewExists(viewName);
    }

    public boolean tableOrViewExists(String name) {
        return this.db.tableOrViewExists(name);
    }

    public <D extends GeoPackageDao<O, ?>, O> D createDao(Class<O> clazz) {
        return GeoPackageDao.createDao(this.db, clazz);
    }

    public static <D extends GeoPackageDao<O, ?>, O> D createDao(GeoPackageCoreConnection db, Class<O> clazz) {
        GeoPackageDao dao;
        try {
            dao = (GeoPackageDao)DaoManager.createDao((ConnectionSource)db.getConnectionSource(), clazz);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create " + clazz.getSimpleName() + " dao", e);
        }
        dao.setDatabase(db);
        return (D)((Object)dao);
    }

    public static <D extends GeoPackageDao<O, ?>, O> D createDao(GeoPackageCoreConnection db, DatabaseTableConfig<O> tableConfig) throws SQLException {
        GeoPackageDao dao = (GeoPackageDao)DaoManager.createDao((ConnectionSource)db.getConnectionSource(), tableConfig);
        dao.setDatabase(db);
        return (D)((Object)dao);
    }
}

