/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public enum Compression {
    none,
    gzip,
    bzip2;


    public static Compression detect(Path file) {
        if (file.toString().endsWith(".gz")) {
            return gzip;
        }
        if (file.toString().endsWith(".bz2")) {
            return bzip2;
        }
        return none;
    }

    public InputStream decompress(InputStream inputStream) throws IOException {
        return switch (this) {
            case gzip -> new GZIPInputStream(inputStream);
            case bzip2 -> new BZip2CompressorInputStream(inputStream);
            default -> inputStream;
        };
    }

    public OutputStream compress(OutputStream outputStream) throws IOException {
        return switch (this) {
            case gzip -> new GZIPOutputStream(outputStream);
            case bzip2 -> new BZip2CompressorOutputStream(outputStream);
            default -> outputStream;
        };
    }
}

