/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.pmtiles;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.baremaps.tilestore.pmtiles.Entry;
import org.apache.baremaps.tilestore.pmtiles.Header;
import org.apache.baremaps.tilestore.pmtiles.PMTiles;

public class PMTilesReader {
    private final Path path;
    private Header header;
    private List<Entry> rootEntries;

    public PMTilesReader(Path path) {
        this.path = path;
    }

    public Header getHeader() {
        if (this.header == null) {
            try (LittleEndianDataInputStream inputStream = new LittleEndianDataInputStream(Files.newInputStream(this.path, new OpenOption[0]));){
                this.header = PMTiles.deserializeHeader((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.header;
    }

    public List<Entry> getRootDirectory() {
        if (this.rootEntries == null) {
            Header header = this.getHeader();
            this.rootEntries = this.getDirectory(header.getRootDirectoryOffset());
        }
        return this.rootEntries;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Entry> getDirectory(long offset) {
        Header header = this.getHeader();
        try (InputStream input = Files.newInputStream(this.path, new OpenOption[0]);){
            List<Entry> list;
            input.skip(offset);
            try (LittleEndianDataInputStream decompressed = new LittleEndianDataInputStream(header.getInternalCompression().decompress(input));){
                list = PMTiles.deserializeEntries((InputStream)decompressed);
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getTile(int z, long x, long y) {
        long tileId = PMTiles.zxyToTileId(z, x, y);
        Header header = this.getHeader();
        List<Entry> entries = this.getRootDirectory();
        Entry entry = PMTiles.findTile(entries, tileId);
        if (entry == null) {
            return null;
        }
        try (FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);){
            ByteBuffer byteBuffer;
            ByteBuffer compressed = ByteBuffer.allocate((int)entry.getLength());
            channel.position(header.getTileDataOffset() + entry.getOffset());
            channel.read(compressed);
            compressed.flip();
            try (ByteArrayInputStream tile = new ByteArrayInputStream(compressed.array());){
                byteBuffer = ByteBuffer.wrap(tile.readAllBytes());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

