/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile.internal;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.storage.shapefile.internal.CommonByteReader;
import org.apache.baremaps.storage.shapefile.internal.DBaseDataType;
import org.apache.baremaps.storage.shapefile.internal.DBaseFieldDescriptor;
import org.apache.baremaps.storage.shapefile.internal.DbaseException;

public class DbaseByteReader
extends CommonByteReader
implements AutoCloseable {
    protected short firstRecordPosition;
    protected short recordLength;
    protected byte[] reservedFiller1 = new byte[2];
    protected byte reservedIncompleteTransaction;
    protected byte reservedEncryptionFlag;
    protected byte[] reservedFreeRecordThread = new byte[4];
    protected byte[] reservedMultiUser = new byte[8];
    protected byte reservedMDXFlag;
    protected byte codePage;
    protected byte[] reservedFiller2 = new byte[2];
    protected byte descriptorTerminator;
    protected byte dbaseVersion;
    protected int rowCount;
    protected Charset charset;
    protected byte[] dbaseLastUpdate = new byte[3];
    private List<DBaseFieldDescriptor> fieldsDescriptors = new ArrayList<DBaseFieldDescriptor>();
    private Properties info;

    public DbaseByteReader(File dbase3File, Properties connectionInfos) throws IOException {
        super(dbase3File);
        String recordCharset;
        this.info = connectionInfos;
        if (this.info != null && (recordCharset = (String)this.info.get("record_charset")) != null) {
            Charset cs = Charset.forName(recordCharset);
            this.setCharset(cs);
        }
        this.loadDescriptor();
    }

    public void loadRow(DataRow row) {
        this.getByteBuffer().get();
        boolean check = this.nextRowAvailable();
        for (DBaseFieldDescriptor fieldDescriptor : this.fieldsDescriptors) {
            int length;
            byte[] data = new byte[fieldDescriptor.getLength()];
            this.getByteBuffer().get(data);
            for (length = data.length; length != 0 && Byte.toUnsignedInt(data[length - 1]) <= 32; --length) {
            }
            String value = new String(data, 0, length);
            String object = switch (fieldDescriptor.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case DBaseDataType.Character -> value;
                case DBaseDataType.Number -> this.getNumber(fieldDescriptor, value);
                case DBaseDataType.Currency -> Double.parseDouble(value.trim());
                case DBaseDataType.Integer -> Integer.parseInt(value.trim());
                case DBaseDataType.Double -> Double.parseDouble(value.trim());
                case DBaseDataType.AutoIncrement -> Integer.parseInt(value.trim());
                case DBaseDataType.Logical -> value;
                case DBaseDataType.Date -> value;
                case DBaseDataType.Memo -> value;
                case DBaseDataType.FloatingPoint -> value;
                case DBaseDataType.Picture -> value;
                case DBaseDataType.VariField -> value;
                case DBaseDataType.Variant -> value;
                case DBaseDataType.TimeStamp -> value;
                case DBaseDataType.DateTime -> value;
            };
            row.set(fieldDescriptor.getName(), (Object)object);
        }
    }

    private Object getNumber(DBaseFieldDescriptor fd, String value) {
        if (fd.getDecimalCount() == 0) {
            return Long.parseLong(value.trim());
        }
        return Double.parseDouble(value.trim());
    }

    public boolean nextRowAvailable() {
        if (!this.getByteBuffer().hasRemaining()) {
            return false;
        }
        byte eofCheck = this.getByteBuffer().get();
        if (eofCheck == 26) {
            return false;
        }
        int position = this.getByteBuffer().position();
        this.getByteBuffer().position(position - 1);
        return true;
    }

    public int getRowNum() {
        int position = this.getByteBuffer().position();
        int recordNumber = (position - Short.toUnsignedInt(this.firstRecordPosition)) / Short.toUnsignedInt(this.recordLength);
        return recordNumber;
    }

    public Map<String, byte[]> readNextRowAsObjects() {
        this.getByteBuffer().get();
        HashMap<String, byte[]> fieldsValues = new HashMap<String, byte[]>();
        for (DBaseFieldDescriptor fd : this.fieldsDescriptors) {
            int length;
            byte[] data = new byte[fd.getLength()];
            this.getByteBuffer().get(data);
            for (length = data.length; length != 0 && Byte.toUnsignedInt(data[length - 1]) <= 32; --length) {
            }
            if (length != data.length) {
                byte[] dataTrimmed = new byte[length];
                for (int index = 0; index < length; ++index) {
                    dataTrimmed[index] = data[index];
                }
                fieldsValues.put(fd.getName(), dataTrimmed);
                continue;
            }
            fieldsValues.put(fd.getName(), data);
        }
        return fieldsValues;
    }

    private void loadDescriptor() throws IOException {
        try {
            this.dbaseVersion = this.getByteBuffer().get();
            this.getByteBuffer().get(this.dbaseLastUpdate);
            this.getByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            this.rowCount = this.getByteBuffer().getInt();
            this.firstRecordPosition = this.getByteBuffer().getShort();
            this.recordLength = this.getByteBuffer().getShort();
            this.getByteBuffer().order(ByteOrder.BIG_ENDIAN);
            this.getByteBuffer().get(this.reservedFiller1);
            this.reservedIncompleteTransaction = this.getByteBuffer().get();
            this.reservedEncryptionFlag = this.getByteBuffer().get();
            this.getByteBuffer().get(this.reservedFreeRecordThread);
            this.getByteBuffer().get(this.reservedMultiUser);
            this.reservedMDXFlag = this.getByteBuffer().get();
            this.codePage = this.getByteBuffer().get();
            if (this.charset == null) {
                try {
                    this.charset = this.toCharset(this.codePage);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
            this.getByteBuffer().get(this.reservedFiller2);
            while (this.getByteBuffer().position() < this.firstRecordPosition - 1) {
                DBaseFieldDescriptor fd = new DBaseFieldDescriptor(this.getByteBuffer());
                this.fieldsDescriptors.add(fd);
            }
            this.descriptorTerminator = this.getByteBuffer().get();
            if (this.descriptorTerminator != 13) {
                throw new DbaseException("File descriptor problem");
            }
        }
        catch (BufferUnderflowException e) {
            throw new DbaseException("File descriptor problem");
        }
    }

    public List<DBaseFieldDescriptor> getFieldsDescriptors() {
        return this.fieldsDescriptors;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Date getDateOfLastUpdate() {
        return this.toDate(this.dbaseLastUpdate);
    }

    public short getFirstRecordPosition() {
        return this.firstRecordPosition;
    }

    public short getRecordLength() {
        return this.recordLength;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    protected Charset toCharset(byte codePageBinaryValue) throws UnsupportedCharsetException {
        String dbfCodePage = this.toCodePage(codePageBinaryValue);
        if (dbfCodePage == null) {
            throw new UnsupportedCharsetException("Unsupported codepage");
        }
        try {
            return Charset.forName(dbfCodePage);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong charset selection");
        }
    }

    private String toCodePage(byte pageCodeBinaryValue) {
        HashMap<Integer, String> knownConversions = new HashMap<Integer, String>();
        knownConversions.put(1, "cp437");
        knownConversions.put(2, "cp850");
        knownConversions.put(3, "cp1252");
        knownConversions.put(8, "cp865");
        knownConversions.put(9, "cp437");
        knownConversions.put(10, "cp850");
        knownConversions.put(11, "cp437");
        knownConversions.put(13, "cp437");
        knownConversions.put(14, "cp850");
        knownConversions.put(15, "cp437");
        knownConversions.put(16, "cp850");
        knownConversions.put(17, "cp437");
        knownConversions.put(18, "cp850");
        knownConversions.put(19, "cp932");
        knownConversions.put(20, "cp850");
        knownConversions.put(21, "cp437");
        knownConversions.put(22, "cp850");
        knownConversions.put(23, "cp865");
        knownConversions.put(24, "cp437");
        knownConversions.put(25, "cp437");
        knownConversions.put(26, "cp850");
        knownConversions.put(27, "cp437");
        knownConversions.put(28, "cp863");
        knownConversions.put(29, "cp850");
        knownConversions.put(31, "cp852");
        knownConversions.put(34, "cp852");
        knownConversions.put(35, "cp852");
        knownConversions.put(36, "cp860");
        knownConversions.put(37, "cp850");
        knownConversions.put(38, "cp866");
        knownConversions.put(55, "cp850");
        knownConversions.put(64, "cp852");
        knownConversions.put(77, "cp936");
        knownConversions.put(78, "cp949");
        knownConversions.put(79, "cp950");
        knownConversions.put(80, "cp874");
        knownConversions.put(87, "cp1252");
        knownConversions.put(88, "cp1252");
        knownConversions.put(89, "cp1252");
        knownConversions.put(100, "cp852");
        knownConversions.put(101, "cp866");
        knownConversions.put(102, "cp865");
        knownConversions.put(103, "cp861");
        knownConversions.put(106, "cp737");
        knownConversions.put(107, "cp857");
        knownConversions.put(108, "cp863");
        knownConversions.put(120, "cp950");
        knownConversions.put(121, "cp949");
        knownConversions.put(122, "cp936");
        knownConversions.put(123, "cp932");
        knownConversions.put(124, "cp874");
        knownConversions.put(134, "cp737");
        knownConversions.put(135, "cp852");
        knownConversions.put(136, "cp857");
        knownConversions.put(200, "cp1250");
        knownConversions.put(201, "cp1251");
        knownConversions.put(202, "cp1254");
        knownConversions.put(203, "cp1253");
        knownConversions.put(204, "cp1257");
        return (String)knownConversions.get(Byte.toUnsignedInt(pageCodeBinaryValue));
    }

    public void setCharset(Charset cs) {
        this.charset = cs;
    }

    private Date toDate(byte[] yymmdd) {
        Objects.requireNonNull(yymmdd, "the yymmdd bytes cannot be null");
        if (yymmdd.length != 3) {
            throw new IllegalArgumentException(MessageFormat.format("Database:toDate() works only on a 3 bytes YY MM DD date. this array has {0} length", yymmdd.length));
        }
        Objects.requireNonNull(Byte.valueOf(yymmdd[0]), "the year byte cannot be null");
        Objects.requireNonNull(Byte.valueOf(yymmdd[1]), "the month byte cannot be null");
        Objects.requireNonNull(Byte.valueOf(yymmdd[2]), "the day byte cannot be null");
        int year = yymmdd[0] < 70 ? 100 + yymmdd[0] : yymmdd[0];
        byte month = yymmdd[1];
        byte day = yymmdd[2];
        Date date = new Date(year, month, day);
        return date;
    }
}

