/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;

public class IntegerArrayDataType
implements DataType<int[]> {
    @Override
    public int size(int[] values) {
        return 4 + values.length * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, int[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (int value : values) {
            buffer.putInt(p, value);
            p += 4;
        }
    }

    @Override
    public int[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 4;
        int[] values = new int[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.getInt(position + 4 + index * 4);
        }
        return values;
    }
}

