/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.algorithm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.hprtree.HPRtree;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.roaringbitmap.longlong.Roaring64Bitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionStream {
    private static final Logger logger = LoggerFactory.getLogger(UnionStream.class);
    private final List<Geometry> list;

    public UnionStream(List<Geometry> list) {
        this.list = list;
    }

    public Stream<Geometry> union() {
        Roaring64Bitmap visited = new Roaring64Bitmap();
        HPRtree tree = new HPRtree();
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            tree.insert(this.list.get(i2).getEnvelopeInternal(), (Object)i2);
        }
        tree.build();
        Stream<Geometry> stream = IntStream.range(0, this.list.size()).mapToObj(i -> {
            if (visited.contains((long)i)) {
                return null;
            }
            visited.add(new long[]{i});
            ArrayList<Geometry> accumulator = new ArrayList<Geometry>();
            ArrayDeque<Geometry> stack = new ArrayDeque<Geometry>();
            Geometry g = this.list.get(i);
            accumulator.add(g);
            stack.push(g);
            while (!stack.isEmpty()) {
                Geometry g1 = (Geometry)stack.pop();
                tree.query(g1.getEnvelopeInternal(), o -> {
                    int j = (Integer)o;
                    if (visited.contains((long)j)) {
                        return;
                    }
                    visited.add(new long[]{j});
                    Geometry g2 = this.list.get(j);
                    try {
                        if (g1.intersects(g2)) {
                            accumulator.add(g2);
                            stack.push(g2);
                        }
                    }
                    catch (TopologyException e) {
                        logger.warn("Failed to union geometries", (Throwable)e);
                        logger.warn("Geometry 1: {}", (Object)g1);
                        logger.warn("Geometry 2: {}", (Object)g2);
                    }
                });
            }
            return new UnaryUnionOp(accumulator).union();
        });
        return stream.filter(Objects::nonNull);
    }
}

