/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.rtree;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.extension.rtree.GeometryFunction;
import mil.nga.geopackage.extension.rtree.RTreeIndexCoreExtension;
import mil.nga.geopackage.extension.rtree.RTreeIndexTableDao;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.sf.GeometryEnvelope;
import org.sqlite.Function;

public class RTreeIndexExtension
extends RTreeIndexCoreExtension {
    private static final Logger log = Logger.getLogger(RTreeIndexExtension.class.getName());

    public RTreeIndexExtension(GeoPackage geoPackage) {
        super((GeoPackageCore)geoPackage);
    }

    public GeoPackage getGeoPackage() {
        return (GeoPackage)super.getGeoPackage();
    }

    public RTreeIndexTableDao getTableDao(String featureTable) {
        return this.getTableDao(this.getGeoPackage().getFeatureDao(featureTable));
    }

    public RTreeIndexTableDao getTableDao(FeatureDao featureDao) {
        GeoPackageConnection connection = this.getGeoPackage().getConnection();
        UserCustomTable userCustomTable = this.getRTreeTable((FeatureTable)featureDao.getTable());
        UserCustomDao userCustomDao = new UserCustomDao(this.geoPackage.getName(), connection, userCustomTable);
        return new RTreeIndexTableDao(this, userCustomDao, featureDao);
    }

    public void createMinXFunction() {
        this.createFunction(new GeometryFunction("ST_MinX"){

            @Override
            public Object execute(GeoPackageGeometryData data) {
                Double value = null;
                GeometryEnvelope envelope = RTreeIndexExtension.this.getEnvelope(data);
                if (envelope != null) {
                    value = envelope.getMinX();
                }
                return value;
            }
        });
    }

    public void createMaxXFunction() {
        this.createFunction(new GeometryFunction("ST_MaxX"){

            @Override
            public Object execute(GeoPackageGeometryData data) {
                Double value = null;
                GeometryEnvelope envelope = RTreeIndexExtension.this.getEnvelope(data);
                if (envelope != null) {
                    value = envelope.getMaxX();
                }
                return value;
            }
        });
    }

    public void createMinYFunction() {
        this.createFunction(new GeometryFunction("ST_MinY"){

            @Override
            public Object execute(GeoPackageGeometryData data) {
                Double value = null;
                GeometryEnvelope envelope = RTreeIndexExtension.this.getEnvelope(data);
                if (envelope != null) {
                    value = envelope.getMinY();
                }
                return value;
            }
        });
    }

    public void createMaxYFunction() {
        this.createFunction(new GeometryFunction("ST_MaxY"){

            @Override
            public Object execute(GeoPackageGeometryData data) {
                Double value = null;
                GeometryEnvelope envelope = RTreeIndexExtension.this.getEnvelope(data);
                if (envelope != null) {
                    value = envelope.getMaxY();
                }
                return value;
            }
        });
    }

    public void createIsEmptyFunction() {
        this.createFunction(new GeometryFunction("ST_IsEmpty"){

            @Override
            public Object execute(GeoPackageGeometryData data) {
                Integer value = null;
                if (data != null) {
                    value = data.isEmpty() || data.getGeometry() == null ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                return value;
            }
        });
    }

    private void createFunction(GeometryFunction function) {
        try {
            Function.create((Connection)this.getGeoPackage().getConnection().getConnection(), (String)function.getName(), (Function)function);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Failed to create function: " + function.getName(), e);
        }
    }
}

