/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.spi.LoggingSystem;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.util.Lazy;

public final class JsonUtils {
    private static final char[] HC = "0123456789ABCDEF".toCharArray();
    private static final Lazy<int[]> ESC_CODES = Lazy.pure(() -> {
        int[] table = new int[128];
        for (int i = 0; i < 32; ++i) {
            table[i] = -1;
        }
        table[34] = 34;
        table[92] = 92;
        table[8] = 98;
        table[9] = 116;
        table[12] = 102;
        table[10] = 110;
        table[13] = 114;
        return table;
    });
    private static final Recycler<char[]> qbufRecycler = LoggingSystem.getRecyclerFactory().create(() -> {
        char[] qbuf = new char[6];
        qbuf[0] = 92;
        qbuf[2] = 48;
        qbuf[3] = 48;
        return qbuf;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quoteAsString(CharSequence input, StringBuilder output) {
        block5: {
            char[] qbuf = (char[])qbufRecycler.acquire();
            try {
                int[] escCodes = (int[])ESC_CODES.get();
                int escCodeCount = escCodes.length;
                int inPtr = 0;
                int inputLen = input.length();
                while (inPtr < inputLen) {
                    char c;
                    while ((c = input.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                        output.append(c);
                        if (++inPtr < inputLen) continue;
                        break block5;
                    }
                    char d = input.charAt(inPtr++);
                    int escCode = escCodes[d];
                    int length = escCode < 0 ? JsonUtils._appendNumeric(d, qbuf) : JsonUtils._appendNamed(escCode, qbuf);
                    output.append(qbuf, 0, length);
                }
            }
            finally {
                qbufRecycler.release((Object)qbuf);
            }
        }
    }

    private static int _appendNumeric(int value, char[] qbuf) {
        qbuf[1] = 117;
        qbuf[4] = HC[value >> 4];
        qbuf[5] = HC[value & 0xF];
        return 6;
    }

    private static int _appendNamed(int esc, char[] qbuf) {
        qbuf[1] = (char)esc;
        return 2;
    }
}

