/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.TextEncoderHelper;
import org.apache.logging.log4j.core.util.Constants;

public class StringBuilderEncoder
implements Encoder<StringBuilder> {
    private final CharsetEncoder charsetEncoder;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private final Charset charset;

    public StringBuilderEncoder(Charset charset) {
        this(charset, Constants.ENCODER_CHAR_BUFFER_SIZE, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    public StringBuilderEncoder(Charset charset, int charBufferSize, int byteBufferSize) {
        this.charset = Objects.requireNonNull(charset, "charset");
        this.charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charBuffer = CharBuffer.allocate(charBufferSize);
        this.byteBuffer = ByteBuffer.allocate(byteBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(StringBuilder source, ByteBufferDestination destination) {
        try {
            TextEncoderHelper.encodeText(this.charsetEncoder, this.charBuffer, this.byteBuffer, source, destination);
        }
        catch (Exception error) {
            TextEncoderHelper.encodeTextFallback(this.charset, source, destination, error);
        }
        finally {
            this.charsetEncoder.reset();
            this.charBuffer.clear();
            this.byteBuffer.clear();
        }
    }
}

