/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.condition;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.condition.Condition;
import org.apache.logging.log4j.plugins.condition.ConditionContext;
import org.apache.logging.log4j.plugins.condition.ConditionalOnProperty;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.status.StatusLogger;

public class OnPropertyCondition
implements Condition {
    private static final Logger LOGGER = StatusLogger.getLogger();

    @Override
    public boolean matches(ConditionContext context, AnnotatedElement element) {
        return OnPropertyCondition.conditionals(element).allMatch(annotation -> {
            String name = annotation.name();
            String value = annotation.value();
            String property = context.getEnvironment().getStringProperty(name);
            boolean matchIfMissing = annotation.matchIfMissing();
            boolean result = OnPropertyCondition.propertyMatches(property, value, matchIfMissing);
            LOGGER.debug("ConditionalOnProperty {} for name='{}', value='{}'; property='{}', matchIfMissing={}", (Object)result, (Object)name, (Object)value, (Object)property, (Object)matchIfMissing);
            return result;
        });
    }

    private static Stream<ConditionalOnProperty> conditionals(AnnotatedElement element) {
        Stream<ConditionalOnProperty> elementAnnotations = AnnotationUtil.findLogicalAnnotations(element, ConditionalOnProperty.class);
        if (element instanceof Method) {
            Class<?> declaringClass = ((Method)element).getDeclaringClass();
            Stream<ConditionalOnProperty> declaringClassAnnotations = AnnotationUtil.findLogicalAnnotations(declaringClass, ConditionalOnProperty.class);
            return Stream.concat(elementAnnotations, declaringClassAnnotations);
        }
        return elementAnnotations;
    }

    private static boolean propertyMatches(String property, String value, boolean matchIfMissing) {
        if (property == null) {
            return matchIfMissing;
        }
        return value.isEmpty() || value.equalsIgnoreCase(property);
    }
}

