/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectLinkedOpenHashSet;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientHttpService;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.healthcheck.HealthCheckServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckUpdateHandler;
import com.linecorp.armeria.server.healthcheck.HealthCheckUpdateListener;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import com.linecorp.armeria.server.healthcheck.ScheduledHealthChecker;
import com.linecorp.armeria.server.healthcheck.SettableHealthChecker;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckService
implements TransientHttpService {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckService.class);
    private static final AsciiString ARMERIA_LPHC = HttpHeaderNames.of("armeria-lphc");
    private static final PendingResponse[] EMPTY_PENDING_RESPONSES = new PendingResponse[0];
    private final SettableHealthChecker serverHealth;
    private final Set<HealthChecker> healthCheckers;
    private final AggregatedHttpResponse healthyResponse;
    private final AggregatedHttpResponse unhealthyResponse;
    private final AggregatedHttpResponse stoppingResponse;
    private final ResponseHeaders ping;
    private final ResponseHeaders notModifiedHeaders;
    private final long maxLongPollingTimeoutMillis;
    private final double longPollingTimeoutJitterRate;
    private final long pingIntervalMillis;
    private final ReentrantLock lock = new ReentrantShortLock();
    @Nullable
    private final Consumer<HealthChecker> healthCheckerListener;
    @Nullable
    final Set<PendingResponse> pendingHealthyResponses;
    @Nullable
    final Set<PendingResponse> pendingUnhealthyResponses;
    @Nullable
    private final HealthCheckUpdateHandler updateHandler;
    private final boolean startHealthy;
    private final Set<TransientServiceOption> transientServiceOptions;
    @Nullable
    private Server server;
    private boolean serverStopping;

    public static HealthCheckService of(HealthChecker ... healthCheckers) {
        return HealthCheckService.builder().checkers(healthCheckers).build();
    }

    public static HealthCheckService of(Iterable<? extends HealthChecker> healthCheckers) {
        return HealthCheckService.builder().checkers(healthCheckers).build();
    }

    public static HealthCheckServiceBuilder builder() {
        return new HealthCheckServiceBuilder();
    }

    /*
     * Unable to fully structure code
     */
    HealthCheckService(Set<HealthChecker> healthCheckers, AggregatedHttpResponse healthyResponse, AggregatedHttpResponse unhealthyResponse, long maxLongPollingTimeoutMillis, double longPollingTimeoutJitterRate, long pingIntervalMillis, @Nullable HealthCheckUpdateHandler updateHandler, List<HealthCheckUpdateListener> updateListeners, boolean startHealthy, Set<TransientServiceOption> transientServiceOptions) {
        super();
        this.serverHealth = new SettableHealthChecker(false);
        if (!updateListeners.isEmpty()) {
            this.addServerHealthUpdateListener(ImmutableList.copyOf(updateListeners));
        }
        this.healthCheckers = ImmutableSet.builder().add(this.serverHealth).addAll(healthCheckers).build();
        this.updateHandler = updateHandler;
        this.startHealthy = startHealthy;
        this.transientServiceOptions = transientServiceOptions;
        if (maxLongPollingTimeoutMillis <= 0L) ** GOTO lbl-1000
        if (this.healthCheckers.stream().allMatch((Predicate<HealthChecker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/linecorp/armeria/server/healthcheck/HealthChecker;)Z)(ListenableHealthChecker.class))) {
            this.maxLongPollingTimeoutMillis = maxLongPollingTimeoutMillis;
            this.longPollingTimeoutJitterRate = longPollingTimeoutJitterRate;
            this.pingIntervalMillis = pingIntervalMillis;
            this.healthCheckerListener = (Consumer<HealthChecker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, onHealthCheckerUpdate(com.linecorp.armeria.server.healthcheck.HealthChecker ), (Lcom/linecorp/armeria/server/healthcheck/HealthChecker;)V)((HealthCheckService)this);
            this.pendingHealthyResponses = new ObjectLinkedOpenHashSet<PendingResponse>();
            this.pendingUnhealthyResponses = new ObjectLinkedOpenHashSet<PendingResponse>();
        } else lbl-1000:
        // 2 sources

        {
            this.maxLongPollingTimeoutMillis = 0L;
            this.longPollingTimeoutJitterRate = 0.0;
            this.pingIntervalMillis = 0L;
            this.healthCheckerListener = null;
            this.pendingHealthyResponses = null;
            this.pendingUnhealthyResponses = null;
            if (maxLongPollingTimeoutMillis > 0L && HealthCheckService.logger.isWarnEnabled()) {
                HealthCheckService.logger.warn("Long-polling support has been disabled because some of the specified {}s do not implement {}: {}", new Object[]{HealthChecker.class.getSimpleName(), ListenableHealthChecker.class.getSimpleName(), this.healthCheckers.stream().filter((Predicate<HealthChecker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(com.linecorp.armeria.server.healthcheck.HealthChecker ), (Lcom/linecorp/armeria/server/healthcheck/HealthChecker;)Z)()).collect(ImmutableList.toImmutableList())});
            }
        }
        this.healthyResponse = this.setCommonHeaders(healthyResponse);
        this.unhealthyResponse = this.setCommonHeaders(unhealthyResponse);
        this.stoppingResponse = HealthCheckService.clearCommonHeaders(unhealthyResponse);
        this.notModifiedHeaders = ResponseHeaders.builder().add((Iterable)this.unhealthyResponse.headers()).endOfStream(true).status(HttpStatus.NOT_MODIFIED).removeAndThen((CharSequence)HttpHeaderNames.CONTENT_LENGTH).build();
        this.ping = this.setCommonHeaders(ResponseHeaders.of(HttpStatus.PROCESSING));
    }

    private void addServerHealthUpdateListener(ImmutableList<HealthCheckUpdateListener> updateListeners) {
        this.serverHealth.addListener(healthChecker -> updateListeners.forEach(updateListener -> {
            try {
                updateListener.healthUpdated(healthChecker.isHealthy());
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception from HealthCheckUpdateListener.healthUpdated():", t);
            }
        }));
    }

    private AggregatedHttpResponse setCommonHeaders(AggregatedHttpResponse res) {
        return AggregatedHttpResponse.of(res.informationals(), this.setCommonHeaders(res.headers()), res.content(), res.trailers().toBuilder().removeAndThen((CharSequence)ARMERIA_LPHC).build());
    }

    private ResponseHeaders setCommonHeaders(ResponseHeaders headers) {
        long pingIntervalSeconds;
        long maxLongPollingTimeoutSeconds;
        if (this.isLongPollingEnabled()) {
            maxLongPollingTimeoutSeconds = Math.max(1L, this.maxLongPollingTimeoutMillis / 1000L);
            pingIntervalSeconds = Math.max(1L, this.pingIntervalMillis / 1000L);
        } else {
            maxLongPollingTimeoutSeconds = 0L;
            pingIntervalSeconds = 0L;
        }
        return HealthCheckService.setCommonHeaders(headers, maxLongPollingTimeoutSeconds, pingIntervalSeconds);
    }

    private static ResponseHeaders setCommonHeaders(ResponseHeaders headers, long maxLongPollingTimeoutSeconds, long pingIntervalSeconds) {
        return headers.toBuilder().set((CharSequence)ARMERIA_LPHC, maxLongPollingTimeoutSeconds + ", " + pingIntervalSeconds).build();
    }

    private static AggregatedHttpResponse clearCommonHeaders(AggregatedHttpResponse res) {
        return AggregatedHttpResponse.of(res.informationals(), res.headers().toBuilder().removeAndThen((CharSequence)ARMERIA_LPHC).build(), res.content(), res.trailers().toBuilder().removeAndThen((CharSequence)ARMERIA_LPHC).build());
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener(new ServerListenerAdapter(){

            @Override
            public void serverStarting(Server server) throws Exception {
                HealthCheckService.this.serverStopping = false;
                if (HealthCheckService.this.healthCheckerListener != null) {
                    HealthCheckService.this.healthCheckers.stream().map(ListenableHealthChecker.class::cast).forEach(c -> c.addListener(HealthCheckService.this.healthCheckerListener));
                }
                HealthCheckService.this.healthCheckers.stream().filter(ScheduledHealthChecker.class::isInstance).map(ScheduledHealthChecker.class::cast).forEach(ScheduledHealthChecker::startHealthChecker);
            }

            @Override
            public void serverStarted(Server server) {
                if (HealthCheckService.this.startHealthy) {
                    HealthCheckService.this.serverHealth.setHealthy(true);
                }
            }

            @Override
            public void serverStopping(Server server) {
                HealthCheckService.this.serverStopping = true;
                HealthCheckService.this.serverHealth.setHealthy(false);
            }

            @Override
            public void serverStopped(Server server) throws Exception {
                if (HealthCheckService.this.healthCheckerListener != null) {
                    HealthCheckService.this.healthCheckers.stream().map(ListenableHealthChecker.class::cast).forEach(c -> c.removeListener(HealthCheckService.this.healthCheckerListener));
                }
                HealthCheckService.this.healthCheckers.stream().filter(ScheduledHealthChecker.class::isInstance).map(ScheduledHealthChecker.class::cast).forEach(ScheduledHealthChecker::stopHealthChecker);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        String expectedState;
        long longPollingTimeoutMillis = this.getLongPollingTimeoutMillis(req);
        boolean isHealthy = this.isHealthy();
        boolean useLongPolling = longPollingTimeoutMillis > 0L ? ("\"healthy\"".equals(expectedState = Ascii.toLowerCase(req.headers().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH, ""))) || "w/\"healthy\"".equals(expectedState) ? isHealthy : ("\"unhealthy\"".equals(expectedState) || "w/\"unhealthy\"".equals(expectedState) ? !isHealthy : false)) : false;
        HttpMethod method = ctx.method();
        if (useLongPolling) {
            switch (method) {
                case HEAD: 
                case GET: {
                    break;
                }
                default: {
                    throw HttpStatusException.of(HttpStatus.METHOD_NOT_ALLOWED);
                }
            }
            assert (this.healthCheckerListener != null) : "healthCheckerListener is null.";
            assert (this.pendingHealthyResponses != null) : "pendingHealthyResponses is null.";
            assert (this.pendingUnhealthyResponses != null) : "pendingUnhealthyResponses is null.";
            this.lock.lock();
            try {
                boolean currentHealthiness = this.isHealthy();
                if (isHealthy == currentHealthiness) {
                    HttpResponseWriter res = HttpResponse.streaming();
                    Set<PendingResponse> pendingResponses = isHealthy ? this.pendingUnhealthyResponses : this.pendingHealthyResponses;
                    res.write(this.ping);
                    ScheduledFuture pingFuture = this.pingIntervalMillis != 0L && this.pingIntervalMillis < longPollingTimeoutMillis ? ctx.eventLoop().withoutContext().scheduleWithFixedDelay((Runnable)new PingTask(res), this.pingIntervalMillis, this.pingIntervalMillis, TimeUnit.MILLISECONDS) : null;
                    ScheduledFuture timeoutFuture = ctx.eventLoop().withoutContext().schedule((Runnable)new TimeoutTask(res), longPollingTimeoutMillis, TimeUnit.MILLISECONDS);
                    PendingResponse pendingResponse = new PendingResponse(method, res, pingFuture, timeoutFuture);
                    pendingResponses.add(pendingResponse);
                    timeoutFuture.addListener((GenericFutureListener)((FutureListener)f -> {
                        this.lock.lock();
                        try {
                            pendingResponses.remove(pendingResponse);
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }));
                    HealthCheckService.updateRequestTimeout(ctx, longPollingTimeoutMillis);
                    res.whenComplete().handle((unused1, unused2) -> {
                        pendingResponse.cancelAllScheduledFutures();
                        return null;
                    });
                    HttpResponseWriter httpResponseWriter = res;
                    return httpResponseWriter;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        switch (method) {
            case HEAD: 
            case GET: {
                return this.newResponse(method, isHealthy);
            }
            case CONNECT: 
            case DELETE: 
            case OPTIONS: 
            case TRACE: {
                return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
            }
        }
        assert (method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH);
        if (this.updateHandler == null) {
            return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
        }
        return HttpResponse.of(this.updateHandler.handle(ctx, req).thenApply(updateResult -> {
            if (updateResult != null) {
                switch (updateResult) {
                    case HEALTHY: {
                        this.serverHealth.setHealthy(true);
                        break;
                    }
                    case UNHEALTHY: {
                        this.serverHealth.setHealthy(false);
                    }
                }
            }
            return HttpResponse.of(this.newResponse(method, this.isHealthy()));
        }));
    }

    private boolean isHealthy() {
        for (HealthChecker healthChecker : this.healthCheckers) {
            if (healthChecker.isHealthy()) continue;
            return false;
        }
        return true;
    }

    private long getLongPollingTimeoutMillis(HttpRequest req) {
        if (!this.isLongPollingEnabled()) {
            return 0L;
        }
        String prefer = req.headers().get((CharSequence)HttpHeaderNames.PREFER);
        if (prefer == null) {
            return 0L;
        }
        LongHolder timeoutMillisHolder = new LongHolder();
        try {
            ArmeriaHttpUtil.parseDirectives(prefer, (name, value) -> {
                if ("wait".equals(name)) {
                    timeoutMillisHolder.value = TimeUnit.SECONDS.toMillis(Long.parseLong(value));
                }
            });
        }
        catch (NumberFormatException ignored) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        if (timeoutMillisHolder.value <= 0L) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        double multiplier = this.longPollingTimeoutJitterRate > 0.0 ? 1.0 - ThreadLocalRandom.current().nextDouble(this.longPollingTimeoutJitterRate) : 1.0;
        return (long)((double)Math.min(timeoutMillisHolder.value, this.maxLongPollingTimeoutMillis) * multiplier);
    }

    private boolean isLongPollingEnabled() {
        return this.healthCheckerListener != null;
    }

    private static void updateRequestTimeout(ServiceRequestContext ctx, long longPollingTimeoutMillis) {
        long requestTimeoutMillis = ctx.requestTimeoutMillis();
        if (requestTimeoutMillis > 0L) {
            ctx.setRequestTimeoutMillis(TimeoutMode.EXTEND, longPollingTimeoutMillis);
        }
    }

    private HttpResponse newResponse(HttpMethod method, boolean isHealthy) {
        AggregatedHttpResponse aRes = this.getResponse(isHealthy);
        if (method == HttpMethod.HEAD) {
            return HttpResponse.of(aRes.headers());
        }
        return aRes.toHttpResponse();
    }

    private AggregatedHttpResponse getResponse(boolean isHealthy) {
        if (isHealthy) {
            return this.healthyResponse;
        }
        if (this.serverStopping) {
            return this.stoppingResponse;
        }
        return this.unhealthyResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHealthCheckerUpdate(HealthChecker unused) {
        PendingResponse[] pendingResponses;
        assert (this.healthCheckerListener != null) : "healthCheckerListener is null.";
        assert (this.pendingHealthyResponses != null) : "pendingHealthyResponses is null.";
        assert (this.pendingUnhealthyResponses != null) : "pendingUnhealthyResponses is null.";
        boolean isHealthy = this.isHealthy();
        this.lock.lock();
        try {
            Set<PendingResponse> set;
            Set<PendingResponse> set2 = set = isHealthy ? this.pendingHealthyResponses : this.pendingUnhealthyResponses;
            if (!set.isEmpty()) {
                pendingResponses = set.toArray(EMPTY_PENDING_RESPONSES);
                set.clear();
            } else {
                pendingResponses = EMPTY_PENDING_RESPONSES;
            }
        }
        finally {
            this.lock.unlock();
        }
        AggregatedHttpResponse res = this.getResponse(isHealthy);
        for (PendingResponse e : pendingResponses) {
            if (!e.cancelAllScheduledFutures()) continue;
            if (e.method == HttpMethod.HEAD) {
                if (!e.res.tryWrite(res.headers())) continue;
                e.res.close();
                continue;
            }
            e.res.close(res);
        }
    }

    @Override
    public Set<TransientServiceOption> transientServiceOptions() {
        return this.transientServiceOptions;
    }

    private static /* synthetic */ boolean lambda$new$0(HealthChecker e) {
        return !(e instanceof ListenableHealthChecker);
    }

    private class PingTask
    implements Runnable {
        private final HttpResponseWriter res;
        private int pendingPings;

        PingTask(HttpResponseWriter res) {
            this.res = res;
        }

        @Override
        public void run() {
            if (this.pendingPings < 5 && this.res.tryWrite(HealthCheckService.this.ping)) {
                ++this.pendingPings;
                this.res.whenConsumed().thenRun(() -> --this.pendingPings);
            }
        }
    }

    private class TimeoutTask
    implements Runnable {
        private final HttpResponseWriter res;

        TimeoutTask(HttpResponseWriter res) {
            this.res = res;
        }

        @Override
        public void run() {
            if (this.res.tryWrite(HealthCheckService.this.notModifiedHeaders)) {
                this.res.close();
            }
        }
    }

    private static final class PendingResponse {
        final HttpMethod method;
        final HttpResponseWriter res;
        @Nullable
        private final ScheduledFuture<?> pingFuture;
        private final ScheduledFuture<?> timeoutFuture;

        PendingResponse(HttpMethod method, HttpResponseWriter res, @Nullable ScheduledFuture<?> pingFuture, ScheduledFuture<?> timeoutFuture) {
            this.method = method;
            this.res = res;
            this.pingFuture = pingFuture;
            this.timeoutFuture = timeoutFuture;
        }

        boolean cancelAllScheduledFutures() {
            if (this.pingFuture != null) {
                this.pingFuture.cancel(false);
            }
            return this.timeoutFuture.cancel(false);
        }
    }

    private static final class LongHolder {
        long value;

        private LongHolder() {
        }
    }
}

