/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceRequestContext;

final class FallbackService
implements HttpService {
    static final FallbackService INSTANCE = new FallbackService();

    private FallbackService() {
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        RoutingContext routingCtx = ctx.routingContext();
        if (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT) {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.FORBIDDEN);
        }
        HttpStatusException cause = routingCtx.deferredStatusException();
        if (cause == null || cause.httpStatus() == HttpStatus.NOT_FOUND) {
            return FallbackService.handleNotFound(ctx, routingCtx);
        }
        return FallbackService.newFallbackResponse(ctx, cause.httpStatus());
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.REQUEST_STREAMING;
    }

    private static HttpResponse handleNotFound(ServiceRequestContext ctx, RoutingContext routingCtx) {
        String oldPath = routingCtx.path();
        if (oldPath.charAt(oldPath.length() - 1) == '/') {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.NOT_FOUND);
        }
        if (!ctx.config().virtualHost().findServiceConfig(routingCtx.withPath(oldPath + '/')).isPresent()) {
            return FallbackService.newFallbackResponse(ctx, HttpStatus.NOT_FOUND);
        }
        int index = oldPath.lastIndexOf(47);
        assert (index >= 0);
        String location = oldPath.substring(index + 1) + '/';
        if (routingCtx.query() != null) {
            location = location + '?' + routingCtx.query();
        }
        return HttpResponse.of(ResponseHeaders.builder(HttpStatus.TEMPORARY_REDIRECT).add((CharSequence)HttpHeaderNames.LOCATION, location).build());
    }

    private static HttpResponse newFallbackResponse(ServiceRequestContext ctx, HttpStatus status) {
        ServiceErrorHandler errorHandler = ctx.config().errorHandler();
        AggregatedHttpResponse rendered = errorHandler.renderStatus(ctx.config(), ctx.request().headers(), status, null, null);
        if (rendered != null) {
            return rendered.toHttpResponse();
        }
        return HttpResponse.of(ResponseHeaders.builder(status).endOfStream(true).build());
    }
}

