/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.chars;

import com.linecorp.armeria.internal.shaded.fastutil.chars.AbstractCharSet;
import com.linecorp.armeria.internal.shaded.fastutil.chars.CharArrays;
import com.linecorp.armeria.internal.shaded.fastutil.chars.CharConsumer;
import com.linecorp.armeria.internal.shaded.fastutil.chars.CharIterator;
import com.linecorp.armeria.internal.shaded.fastutil.chars.CharSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class CharArraySet
extends AbstractCharSet
implements Serializable,
Cloneable {
    protected transient char[] a;
    protected int size;

    public CharArraySet(char[] a) {
        this.a = a;
        this.size = a.length;
    }

    public CharArraySet() {
        this.a = CharArrays.EMPTY_ARRAY;
    }

    private int findKey(char o) {
        int i = this.size;
        while (i-- != 0) {
            if (this.a[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CharIterator iterator() {
        return new CharIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < CharArraySet.this.size;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CharArraySet.this.a[this.next++];
            }

            @Override
            public void remove() {
                int tail = CharArraySet.this.size-- - this.next--;
                System.arraycopy(CharArraySet.this.a, this.next + 1, CharArraySet.this.a, this.next, tail);
            }
        };
    }

    @Override
    public CharSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public boolean contains(char k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(char k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i = 0; i < tail; ++i) {
            this.a[pos + i] = this.a[pos + i + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(char k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            char[] b = new char[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                b[i] = this.a[i];
            }
            this.a = b;
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public char[] toCharArray() {
        if (this.size == 0) {
            return CharArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, this.size);
    }

    public CharArraySet clone() {
        CharArraySet c;
        try {
            c = (CharArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.a = (char[])this.a.clone();
        return c;
    }

    private final class Spliterator
    implements CharSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, charArraySet.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : CharArraySet.this.size;
        }

        @Override
        public int characteristics() {
            return 16721;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(CharConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(CharArraySet.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(CharConsumer action) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(CharArraySet.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public CharSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

