/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.AbstractLogFormatterBuilder;
import com.linecorp.armeria.common.logging.HeadersSanitizer;
import com.linecorp.armeria.common.logging.JsonLogFormatter;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
public final class JsonLogFormatterBuilder
extends AbstractLogFormatterBuilder<JsonNode> {
    @Nullable
    private ObjectMapper objectMapper;

    JsonLogFormatterBuilder() {
    }

    public JsonLogFormatterBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        return this;
    }

    public JsonLogFormatterBuilder requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestHeadersSanitizer) {
        return (JsonLogFormatterBuilder)super.requestHeadersSanitizer(requestHeadersSanitizer);
    }

    public JsonLogFormatterBuilder responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseHeadersSanitizer) {
        return (JsonLogFormatterBuilder)super.responseHeadersSanitizer(responseHeadersSanitizer);
    }

    public JsonLogFormatterBuilder requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestTrailersSanitizer) {
        return (JsonLogFormatterBuilder)super.requestTrailersSanitizer(requestTrailersSanitizer);
    }

    public JsonLogFormatterBuilder responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseTrailersSanitizer) {
        return (JsonLogFormatterBuilder)super.responseTrailersSanitizer(responseTrailersSanitizer);
    }

    public JsonLogFormatterBuilder headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> headersSanitizer) {
        return (JsonLogFormatterBuilder)super.headersSanitizer(headersSanitizer);
    }

    public JsonLogFormatterBuilder requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> requestContentSanitizer) {
        return (JsonLogFormatterBuilder)super.requestContentSanitizer(requestContentSanitizer);
    }

    public JsonLogFormatterBuilder responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> responseContentSanitizer) {
        return (JsonLogFormatterBuilder)super.responseContentSanitizer(responseContentSanitizer);
    }

    public JsonLogFormatterBuilder contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> contentSanitizer) {
        return (JsonLogFormatterBuilder)super.contentSanitizer(contentSanitizer);
    }

    public LogFormatter build() {
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : JacksonUtil.newDefaultObjectMapper();
        HeadersSanitizer<JsonNode> defaultHeadersSanitizer = JsonLogFormatterBuilder.defaultHeadersSanitizer(objectMapper);
        BiFunction defaultContentSanitizer = JsonLogFormatterBuilder.defaultSanitizer(objectMapper);
        return new JsonLogFormatter(MoreObjects.firstNonNull(this.requestHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.responseHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.requestTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.responseTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.requestContentSanitizer(), defaultContentSanitizer), MoreObjects.firstNonNull(this.responseContentSanitizer(), defaultContentSanitizer), objectMapper);
    }

    private static <T> BiFunction<? super RequestContext, T, JsonNode> defaultSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }

    private static HeadersSanitizer<JsonNode> defaultHeadersSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree((Object)obj);
    }
}

