/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.AbstractHeadersSanitizerBuilder;
import com.linecorp.armeria.common.logging.HeaderMaskingFunction;
import com.linecorp.armeria.common.logging.HeadersSanitizer;
import com.linecorp.armeria.common.logging.JsonHeadersSanitizer;
import com.linecorp.armeria.internal.common.JacksonUtil;
import java.util.Objects;

public final class JsonHeadersSanitizerBuilder
extends AbstractHeadersSanitizerBuilder<JsonNode> {
    @Nullable
    private ObjectMapper objectMapper;

    public JsonHeadersSanitizerBuilder sensitiveHeaders(CharSequence ... headers) {
        return (JsonHeadersSanitizerBuilder)super.sensitiveHeaders(headers);
    }

    public JsonHeadersSanitizerBuilder sensitiveHeaders(Iterable<? extends CharSequence> headers) {
        return (JsonHeadersSanitizerBuilder)super.sensitiveHeaders(headers);
    }

    public JsonHeadersSanitizerBuilder maskingFunction(HeaderMaskingFunction maskingFunction) {
        return (JsonHeadersSanitizerBuilder)super.maskingFunction(maskingFunction);
    }

    public JsonHeadersSanitizerBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        return this;
    }

    public HeadersSanitizer<JsonNode> build() {
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : JacksonUtil.newDefaultObjectMapper();
        return new JsonHeadersSanitizer(this.sensitiveHeaders(), this.maskingFunction(), objectMapper);
    }
}

