/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseCompleteException;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogAvailabilityException;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;

final class DefaultRequestLog
implements RequestLog,
RequestLogBuilder {
    private static final AtomicIntegerFieldUpdater<DefaultRequestLog> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultRequestLog.class, "flags");
    private static final AtomicIntegerFieldUpdater<DefaultRequestLog> deferredFlagsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultRequestLog.class, "deferredFlags");
    private static final RequestHeaders DUMMY_REQUEST_HEADERS_HTTP = RequestHeaders.builder(HttpMethod.UNKNOWN, "?").scheme("http").authority("?").build();
    private static final RequestHeaders DUMMY_REQUEST_HEADERS_HTTPS = RequestHeaders.builder(HttpMethod.UNKNOWN, "?").scheme("https").authority("?").build();
    private static final ResponseHeaders DUMMY_RESPONSE_HEADERS = ResponseHeaders.of(HttpStatus.UNKNOWN);
    private final RequestContext ctx;
    private final CompleteRequestLog notCheckingAccessor = new CompleteRequestLog();
    @Nullable
    private RequestLogAccess parent;
    @Nullable
    private List<RequestLogAccess> children;
    private boolean hasLastChild;
    private volatile int flags;
    private volatile int deferredFlags;
    @GuardedBy(value="lock")
    private final List<RequestLogFuture> pendingFutures = new ArrayList<RequestLogFuture>(4);
    private final Lock lock = new ReentrantShortLock();
    @Nullable
    private UnmodifiableFuture<RequestLog> partiallyCompletedFuture;
    @Nullable
    private UnmodifiableFuture<RequestLog> completedFuture;
    private long requestStartTimeMicros;
    private long requestStartTimeNanos;
    private boolean requestFirstBytesTransferredTimeNanosSet;
    private long requestFirstBytesTransferredTimeNanos;
    private long requestEndTimeNanos;
    private long requestLength;
    @Nullable
    private String requestContentPreview;
    @Nullable
    private Throwable requestCause;
    private long responseStartTimeMicros;
    private long responseStartTimeNanos;
    private boolean responseFirstBytesTransferredTimeNanosSet;
    private long responseFirstBytesTransferredTimeNanos;
    private long responseEndTimeNanos;
    private long responseLength;
    @Nullable
    private String responseContentPreview;
    @Nullable
    private Throwable responseCause;
    @Nullable
    private Channel channel;
    @Nullable
    private SSLSession sslSession;
    @Nullable
    private SessionProtocol sessionProtocol;
    @Nullable
    private ClientConnectionTimings connectionTimings;
    private SerializationFormat serializationFormat = SerializationFormat.NONE;
    @Nullable
    private Scheme scheme;
    @Nullable
    private String serviceName;
    @Nullable
    private String name;
    @Nullable
    private String fullName;
    @Nullable
    private String authenticatedUser;
    @Nullable
    private RequestHeaders requestHeaders;
    private HttpHeaders requestTrailers = HttpHeaders.of();
    @Nullable
    private ResponseHeaders responseHeaders;
    private HttpHeaders responseTrailers = HttpHeaders.of();
    @Nullable
    private Object requestContent;
    @Nullable
    private Object rawRequestContent;
    @Nullable
    private Object responseContent;
    @Nullable
    private Object rawResponseContent;

    DefaultRequestLog(RequestContext ctx) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
    }

    @Override
    public boolean isComplete() {
        return DefaultRequestLog.isComplete(this.flags);
    }

    private static boolean isComplete(int flags) {
        return flags == RequestLogProperty.FLAGS_ALL_COMPLETE;
    }

    @Override
    public boolean isRequestComplete() {
        return DefaultRequestLog.hasInterestedFlags(this.flags, RequestLogProperty.FLAGS_REQUEST_COMPLETE);
    }

    @Override
    public boolean isAvailable(RequestLogProperty property) {
        Objects.requireNonNull(property, "property");
        return DefaultRequestLog.hasInterestedFlags(this.flags, property.flag());
    }

    @Override
    public boolean isAvailable(RequestLogProperty ... properties) {
        Objects.requireNonNull(properties, "properties");
        Preconditions.checkArgument(properties.length != 0, "properties is empty.");
        return this.isAvailable(DefaultRequestLog.interestedFlags(properties));
    }

    @Override
    public boolean isAvailable(Iterable<RequestLogProperty> properties) {
        Objects.requireNonNull(properties, "properties");
        int flags = DefaultRequestLog.interestedFlags(properties);
        Preconditions.checkArgument(flags != 0, "properties is empty.");
        return this.isAvailable(flags);
    }

    private boolean isAvailable(int interestedFlags) {
        return DefaultRequestLog.hasInterestedFlags(this.flags, interestedFlags);
    }

    @Override
    @Nullable
    public RequestLog getIfAvailable(RequestLogProperty ... properties) {
        return this.isAvailable(properties) ? this : null;
    }

    @Override
    @Nullable
    public RequestLog getIfAvailable(Iterable<RequestLogProperty> properties) {
        return this.isAvailable(properties) ? this : null;
    }

    private static boolean hasInterestedFlags(int flags, RequestLogProperty property) {
        return DefaultRequestLog.hasInterestedFlags(flags, property.flag());
    }

    private static boolean hasInterestedFlags(int flags, int interestedFlags) {
        return (flags & interestedFlags) == interestedFlags;
    }

    private static int interestedFlags(RequestLogProperty ... properties) {
        int flags = 0;
        for (RequestLogProperty p : properties) {
            Objects.requireNonNull(p, "properties contains null.");
            flags |= p.flag();
        }
        return flags;
    }

    private static int interestedFlags(Iterable<RequestLogProperty> properties) {
        int flags = 0;
        for (RequestLogProperty p : properties) {
            Objects.requireNonNull(p, "properties contains null.");
            flags |= p.flag();
        }
        return flags;
    }

    @Override
    public RequestLog partial() {
        return this.partial(this.flags);
    }

    private RequestLog partial(int flags) {
        return DefaultRequestLog.isComplete(flags) ? this.notCheckingAccessor : this;
    }

    @Override
    public CompletableFuture<RequestLog> whenComplete() {
        return this.future(RequestLogProperty.FLAGS_ALL_COMPLETE);
    }

    @Override
    public CompletableFuture<RequestOnlyLog> whenRequestComplete() {
        return this.future(RequestLogProperty.FLAGS_REQUEST_COMPLETE);
    }

    @Override
    public CompletableFuture<RequestLog> whenAvailable(RequestLogProperty property) {
        return this.future(Objects.requireNonNull(property, "property").flag());
    }

    @Override
    public CompletableFuture<RequestLog> whenAvailable(RequestLogProperty ... properties) {
        return this.future(RequestLogProperty.flags(Objects.requireNonNull(properties, "properties")));
    }

    @Override
    public CompletableFuture<RequestLog> whenAvailable(Iterable<RequestLogProperty> properties) {
        return this.future(RequestLogProperty.flags(Objects.requireNonNull(properties, "properties")));
    }

    @Override
    public RequestLog ensureComplete() {
        if (!this.isComplete()) {
            throw new RequestLogAvailabilityException(RequestLog.class.getSimpleName() + " not complete");
        }
        return this.notCheckingAccessor;
    }

    @Override
    public RequestOnlyLog ensureRequestComplete() {
        if (!this.isRequestComplete()) {
            throw new RequestLogAvailabilityException(RequestOnlyLog.class.getSimpleName() + " not complete");
        }
        return this;
    }

    @Override
    public RequestLog ensureAvailable(RequestLogProperty property) {
        if (!this.isAvailable(property)) {
            throw new RequestLogAvailabilityException(property.name());
        }
        return this;
    }

    @Override
    public RequestLog ensureAvailable(RequestLogProperty ... properties) {
        if (!this.isAvailable(properties)) {
            throw new RequestLogAvailabilityException(Arrays.toString((Object[])properties));
        }
        return this;
    }

    @Override
    public RequestLog ensureAvailable(Iterable<RequestLogProperty> properties) {
        if (!this.isAvailable(properties)) {
            throw new RequestLogAvailabilityException(properties.toString());
        }
        return this;
    }

    @Override
    public int availabilityStamp() {
        return this.flags;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    @Override
    @Nullable
    public RequestLogAccess parent() {
        return this.parent;
    }

    @Override
    public List<RequestLogAccess> children() {
        return this.children != null ? ImmutableList.copyOf(this.children) : ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends RequestOnlyLog> CompletableFuture<T> future(int interestedFlags) {
        EventLoopCheckingFuture future;
        if (interestedFlags == 0) {
            throw new IllegalArgumentException("no availability specified");
        }
        int flags = this.flags;
        if (DefaultRequestLog.hasInterestedFlags(flags, interestedFlags)) {
            future = this.completedFuture(flags);
        } else {
            RequestLogFuture[] satisfiedFutures;
            RequestLogFuture newFuture = new RequestLogFuture(interestedFlags);
            this.lock.lock();
            try {
                this.pendingFutures.add(newFuture);
                satisfiedFutures = this.removeSatisfiedFutures(this.pendingFutures);
            }
            finally {
                this.lock.unlock();
            }
            if (satisfiedFutures != null) {
                DefaultRequestLog.completeSatisfiedFutures(satisfiedFutures, this.partial(flags), this.ctx);
            }
            future = newFuture;
        }
        UnmodifiableFuture<RequestLog> cast = future;
        return cast;
    }

    private UnmodifiableFuture<RequestLog> completedFuture(int flags) {
        if (DefaultRequestLog.isComplete(flags)) {
            if (this.completedFuture == null) {
                this.completedFuture = UnmodifiableFuture.completedFuture(this.notCheckingAccessor);
            }
            return this.completedFuture;
        }
        if (this.partiallyCompletedFuture == null) {
            this.partiallyCompletedFuture = UnmodifiableFuture.completedFuture(this);
        }
        return this.partiallyCompletedFuture;
    }

    private void updateFlags(RequestLogProperty property) {
        this.updateFlags(property.flag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlags(int flags) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | flags)) {
            RequestLogFuture[] satisfiedFutures;
            if (!flagsUpdater.compareAndSet(this, oldFlags, newFlags)) continue;
            this.lock.lock();
            try {
                satisfiedFutures = this.removeSatisfiedFutures(this.pendingFutures);
            }
            finally {
                this.lock.unlock();
            }
            if (satisfiedFutures == null) break;
            RequestLog log = this.partial(newFlags);
            DefaultRequestLog.completeSatisfiedFutures(satisfiedFutures, log, this.ctx);
            break;
        }
    }

    private static void completeSatisfiedFutures(RequestLogFuture[] satisfiedFutures, RequestLog log, RequestContext ctx) {
        if (!ctx.eventLoop().inEventLoop()) {
            ctx.eventLoop().execute(() -> DefaultRequestLog.completeSatisfiedFutures(satisfiedFutures, log, ctx));
            return;
        }
        for (RequestLogFuture f : satisfiedFutures) {
            if (f == null) break;
            f.completeLog(log);
        }
    }

    @Nullable
    private RequestLogFuture[] removeSatisfiedFutures(List<RequestLogFuture> pendingFutures) {
        if (pendingFutures.isEmpty()) {
            return null;
        }
        int maxNumListeners = pendingFutures.size();
        Iterator<RequestLogFuture> i = pendingFutures.iterator();
        RequestLogFuture[] satisfied = null;
        int numSatisfied = 0;
        do {
            RequestLogFuture e = i.next();
            int interestedFlags = e.interestedFlags;
            if ((this.flags & interestedFlags) != interestedFlags) continue;
            i.remove();
            if (satisfied == null) {
                satisfied = new RequestLogFuture[maxNumListeners];
            }
            satisfied[numSatisfied++] = e;
        } while (i.hasNext());
        return satisfied;
    }

    @Override
    public boolean isDeferred(RequestLogProperty property) {
        Objects.requireNonNull(property, "property");
        int flag = property.flag();
        return this.isDeferred(flag);
    }

    @Override
    public boolean isDeferred(RequestLogProperty ... properties) {
        Objects.requireNonNull(properties, "properties");
        Preconditions.checkArgument(properties.length != 0, "properties is empty.");
        return this.isDeferred(DefaultRequestLog.interestedFlags(properties));
    }

    @Override
    public boolean isDeferred(Iterable<RequestLogProperty> properties) {
        Objects.requireNonNull(properties, "properties");
        int flags = DefaultRequestLog.interestedFlags(properties);
        Preconditions.checkArgument(flags != 0, "properties is empty.");
        return this.isDeferred(flags);
    }

    private boolean isDeferred(int flag) {
        return (this.deferredFlags & flag) == flag;
    }

    @Override
    public void defer(RequestLogProperty property) {
        Objects.requireNonNull(property, "property");
        this.defer(property.flag());
    }

    @Override
    public void defer(RequestLogProperty ... properties) {
        Objects.requireNonNull(properties, "properties");
        this.defer(DefaultRequestLog.interestedFlags(properties));
    }

    @Override
    public void defer(Iterable<RequestLogProperty> properties) {
        Objects.requireNonNull(properties, "properties");
        this.defer(DefaultRequestLog.interestedFlags(properties));
    }

    private void defer(int flag) {
        int newFlags;
        int oldFlags;
        if (DefaultRequestLog.hasInterestedFlags(flag, RequestLogProperty.REQUEST_CONTENT.flag())) {
            flag |= RequestLogProperty.NAME.flag();
        }
        while ((oldFlags = this.deferredFlags) != (newFlags = oldFlags | flag) && !deferredFlagsUpdater.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public void addChild(RequestLogAccess child) {
        Preconditions.checkState(!this.hasLastChild, "last child is already added");
        Objects.requireNonNull(child, "child");
        if (child instanceof DefaultRequestLog) {
            Preconditions.checkState(((DefaultRequestLog)child).parent == null, "child has parent already");
            ((DefaultRequestLog)child).parent = this;
        }
        if (this.children == null) {
            this.children = new ArrayList<RequestLogAccess>();
            this.propagateRequestSideLog(child);
        }
        this.children.add(child);
    }

    private void propagateRequestSideLog(RequestLogAccess child) {
        child.whenAvailable(RequestLogProperty.REQUEST_START_TIME).thenAccept(log -> this.startRequest(log.requestStartTimeNanos(), log.requestStartTimeMicros()));
        child.whenAvailable(RequestLogProperty.SESSION).thenAccept(log -> this.session(log.channel(), log.sessionProtocol(), log.sslSession(), log.connectionTimings()));
        child.whenAvailable(RequestLogProperty.SCHEME).thenAccept(log -> this.serializationFormat(log.scheme().serializationFormat()));
        child.whenAvailable(RequestLogProperty.NAME).thenAccept(log -> {
            String serviceName = log.serviceName();
            String name = log.name();
            if (serviceName != null) {
                this.name(serviceName, name);
            } else {
                this.name(name);
            }
        });
        child.whenAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(log -> {
            Long timeNanos = log.requestFirstBytesTransferredTimeNanos();
            if (timeNanos != null) {
                this.requestFirstBytesTransferred(timeNanos);
            }
        });
        child.whenAvailable(RequestLogProperty.REQUEST_HEADERS).thenAccept(log -> this.requestHeaders(log.requestHeaders()));
        child.whenAvailable(RequestLogProperty.REQUEST_CONTENT).thenAccept(log -> this.requestContent(log.requestContent(), log.rawRequestContent()));
        child.whenRequestComplete().thenAccept(log -> {
            this.requestLength(log.requestLength());
            this.requestContentPreview(log.requestContentPreview());
            this.requestTrailers(log.requestTrailers());
            this.endRequest0(null, log.requestEndTimeNanos());
        });
    }

    @Override
    public void endResponseWithLastChild() {
        Preconditions.checkState(!this.hasLastChild, "last child is already added");
        Preconditions.checkState(this.children != null && !this.children.isEmpty(), "at least one child should be already added");
        this.hasLastChild = true;
        RequestLogAccess lastChild = this.children.get(this.children.size() - 1);
        this.propagateResponseSideLog(lastChild.partial());
    }

    private void propagateResponseSideLog(RequestLog lastChild) {
        Throwable responseCause;
        if (lastChild.isAvailable(RequestLogProperty.RESPONSE_CAUSE) && (responseCause = lastChild.responseCause()) != null) {
            this.responseCause(responseCause);
        }
        if (lastChild.isAvailable(RequestLogProperty.RESPONSE_START_TIME)) {
            this.startResponse(lastChild.responseStartTimeNanos(), lastChild.responseStartTimeMicros(), true);
        } else {
            lastChild.whenAvailable(RequestLogProperty.RESPONSE_START_TIME).thenAccept(log -> this.startResponse(log.responseStartTimeNanos(), log.responseStartTimeMicros(), true));
        }
        if (lastChild.isAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME)) {
            Long timeNanos = lastChild.responseFirstBytesTransferredTimeNanos();
            if (timeNanos != null) {
                this.responseFirstBytesTransferred(timeNanos);
            }
        } else {
            lastChild.whenAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(log -> {
                Long timeNanos = log.responseFirstBytesTransferredTimeNanos();
                if (timeNanos != null) {
                    this.responseFirstBytesTransferred(timeNanos);
                }
            });
        }
        if (lastChild.isAvailable(RequestLogProperty.RESPONSE_HEADERS)) {
            this.responseHeaders(lastChild.responseHeaders());
        } else {
            lastChild.whenAvailable(RequestLogProperty.RESPONSE_HEADERS).thenAccept(log -> this.responseHeaders(log.responseHeaders()));
        }
        if (lastChild.isAvailable(RequestLogProperty.RESPONSE_TRAILERS)) {
            this.responseTrailers(lastChild.responseTrailers());
        } else {
            lastChild.whenAvailable(RequestLogProperty.RESPONSE_TRAILERS).thenAccept(log -> this.responseTrailers(log.responseTrailers()));
        }
        if (lastChild.isComplete()) {
            this.propagateResponseEndData(lastChild);
        } else {
            lastChild.whenComplete().thenAccept(this::propagateResponseEndData);
        }
    }

    private void propagateResponseEndData(RequestLog log) {
        this.responseContent(log.responseContent(), log.rawResponseContent());
        this.responseLength(log.responseLength());
        this.responseContentPreview(log.responseContentPreview());
        this.responseTrailers(log.responseTrailers());
        this.endResponse0(log.responseCause(), log.responseEndTimeNanos());
    }

    @Override
    public void startRequest(long requestStartTimeNanos, long requestStartTimeMicros) {
        if (this.isAvailable(RequestLogProperty.REQUEST_START_TIME)) {
            return;
        }
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
        this.updateFlags(RequestLogProperty.REQUEST_START_TIME);
    }

    @Override
    public long requestStartTimeMicros() {
        this.ensureAvailable(RequestLogProperty.REQUEST_START_TIME);
        return this.requestStartTimeMicros;
    }

    @Override
    public long requestStartTimeMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.requestStartTimeMicros());
    }

    @Override
    public long requestStartTimeNanos() {
        this.ensureAvailable(RequestLogProperty.REQUEST_START_TIME);
        return this.requestStartTimeNanos;
    }

    @Override
    public Long requestFirstBytesTransferredTimeNanos() {
        this.ensureAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME);
        return this.requestFirstBytesTransferredTimeNanosSet ? Long.valueOf(this.requestFirstBytesTransferredTimeNanos) : null;
    }

    @Override
    public long requestEndTimeNanos() {
        this.ensureAvailable(RequestLogProperty.REQUEST_END_TIME);
        return this.requestEndTimeNanos;
    }

    @Override
    public long requestDurationNanos() {
        this.ensureAvailable(RequestLogProperty.REQUEST_END_TIME);
        return this.requestEndTimeNanos - this.requestStartTimeNanos;
    }

    @Override
    public Throwable requestCause() {
        this.ensureAvailable(RequestLogProperty.REQUEST_CAUSE);
        return this.requestCause;
    }

    @Override
    public void session(@Nullable Channel channel, SessionProtocol sessionProtocol, @Nullable ClientConnectionTimings connectionTimings) {
        if (this.isAvailable(RequestLogProperty.SESSION)) {
            return;
        }
        this.session0(channel, Objects.requireNonNull(sessionProtocol, "sessionProtocol"), ChannelUtil.findSslSession(channel, sessionProtocol), connectionTimings);
    }

    @Override
    public void session(@Nullable Channel channel, SessionProtocol sessionProtocol, @Nullable SSLSession sslSession, @Nullable ClientConnectionTimings connectionTimings) {
        if (this.isAvailable(RequestLogProperty.SESSION)) {
            return;
        }
        this.session0(channel, Objects.requireNonNull(sessionProtocol, "sessionProtocol"), sslSession, connectionTimings);
    }

    private void session0(@Nullable Channel channel, SessionProtocol sessionProtocol, @Nullable SSLSession sslSession, @Nullable ClientConnectionTimings connectionTimings) {
        this.channel = channel;
        this.sslSession = sslSession;
        this.sessionProtocol = sessionProtocol;
        this.connectionTimings = connectionTimings;
        this.maybeSetScheme();
        this.updateFlags(RequestLogProperty.SESSION);
    }

    private void maybeSetScheme() {
        if (this.isAvailable(RequestLogProperty.SCHEME) || this.serializationFormat == SerializationFormat.NONE) {
            return;
        }
        assert (this.sessionProtocol != null);
        this.scheme = Scheme.of(this.serializationFormat, this.sessionProtocol);
        this.updateFlags(RequestLogProperty.SCHEME);
    }

    @Override
    public Channel channel() {
        this.ensureAvailable(RequestLogProperty.SESSION);
        return this.channel;
    }

    @Override
    public SSLSession sslSession() {
        this.ensureAvailable(RequestLogProperty.SESSION);
        return this.sslSession;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        this.ensureAvailable(RequestLogProperty.SESSION);
        assert (this.sessionProtocol != null);
        return this.sessionProtocol;
    }

    @Override
    @Nullable
    public ClientConnectionTimings connectionTimings() {
        this.ensureAvailable(RequestLogProperty.SESSION);
        return this.connectionTimings;
    }

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {
        if (this.isAvailable(RequestLogProperty.SCHEME) || this.serializationFormat != SerializationFormat.NONE) {
            return;
        }
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        if (this.sessionProtocol != null) {
            this.scheme = Scheme.of(serializationFormat, this.sessionProtocol);
            this.updateFlags(RequestLogProperty.SCHEME);
        }
    }

    @Override
    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    @Override
    public Scheme scheme() {
        this.ensureAvailable(RequestLogProperty.SCHEME);
        assert (this.scheme != null);
        return this.scheme;
    }

    @Override
    @Nullable
    public String serviceName() {
        this.ensureAvailable(RequestLogProperty.NAME);
        return this.serviceName;
    }

    @Override
    public String name() {
        this.ensureAvailable(RequestLogProperty.NAME);
        assert (this.name != null);
        return this.name;
    }

    @Override
    public void name(String name) {
        Objects.requireNonNull(name, "name");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty.");
        if (this.isAvailable(RequestLogProperty.NAME)) {
            return;
        }
        this.name = name;
        this.updateFlags(RequestLogProperty.NAME);
    }

    @Override
    public void name(String serviceName, String name) {
        Objects.requireNonNull(serviceName, "serviceName");
        Preconditions.checkArgument(!serviceName.isEmpty(), "serviceName is empty.");
        Objects.requireNonNull(name, "name");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty.");
        if (this.isAvailable(RequestLogProperty.NAME)) {
            return;
        }
        this.serviceName = serviceName;
        this.name = name;
        this.updateFlags(RequestLogProperty.NAME);
    }

    @Override
    public String fullName() {
        this.ensureAvailable(RequestLogProperty.NAME);
        if (this.fullName != null) {
            return this.fullName;
        }
        assert (this.name != null);
        if (this.serviceName != null) {
            this.fullName = this.serviceName + '/' + this.name;
            return this.fullName;
        }
        this.fullName = this.name;
        return this.fullName;
    }

    @Override
    public String authenticatedUser() {
        this.ensureAvailable(RequestLogProperty.AUTHENTICATED_USER);
        return this.authenticatedUser;
    }

    @Override
    public void authenticatedUser(String authenticatedUser) {
        if (this.isAvailable(RequestLogProperty.AUTHENTICATED_USER)) {
            return;
        }
        this.authenticatedUser = Objects.requireNonNull(authenticatedUser, "authenticatedUser");
    }

    @Override
    public long requestLength() {
        this.ensureAvailable(RequestLogProperty.REQUEST_LENGTH);
        return this.requestLength;
    }

    @Override
    public void requestLength(long requestLength) {
        if (requestLength < 0L) {
            throw new IllegalArgumentException("requestLength: " + requestLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogProperty.REQUEST_LENGTH)) {
            return;
        }
        this.requestLength = requestLength;
        this.updateFlags(RequestLogProperty.REQUEST_LENGTH);
    }

    @Override
    public void requestFirstBytesTransferred() {
        if (this.isAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME)) {
            return;
        }
        this.requestFirstBytesTransferred0(System.nanoTime());
    }

    @Override
    public void requestFirstBytesTransferred(long requestFirstBytesTransferredTimeNanos) {
        if (this.isAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME)) {
            return;
        }
        this.requestFirstBytesTransferred0(requestFirstBytesTransferredTimeNanos);
    }

    private void requestFirstBytesTransferred0(long requestFirstBytesTransferredTimeNanos) {
        this.requestFirstBytesTransferredTimeNanos = requestFirstBytesTransferredTimeNanos;
        this.requestFirstBytesTransferredTimeNanosSet = true;
        this.updateFlags(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME);
    }

    @Override
    public void increaseRequestLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogProperty.REQUEST_LENGTH)) {
            return;
        }
        this.requestLength += deltaBytes;
    }

    @Override
    public void increaseRequestLength(HttpData data) {
        Objects.requireNonNull(data, "data");
        this.increaseRequestLength(data.length());
    }

    @Override
    public RequestHeaders requestHeaders() {
        this.ensureAvailable(RequestLogProperty.REQUEST_HEADERS);
        assert (this.requestHeaders != null);
        return this.requestHeaders;
    }

    @Override
    public void requestHeaders(RequestHeaders requestHeaders) {
        if (this.isAvailable(RequestLogProperty.REQUEST_HEADERS)) {
            return;
        }
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders");
        this.updateFlags(RequestLogProperty.REQUEST_HEADERS);
    }

    @Override
    public Object requestContent() {
        this.ensureAvailable(RequestLogProperty.REQUEST_CONTENT);
        return this.requestContent;
    }

    @Override
    public void requestContent(@Nullable Object requestContent, @Nullable Object rawRequestContent) {
        if (this.isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
            return;
        }
        this.requestContent = requestContent;
        this.rawRequestContent = rawRequestContent;
        if (requestContent instanceof RpcRequest && this.ctx.rpcRequest() == null) {
            this.ctx.updateRpcRequest((RpcRequest)requestContent);
        }
        this.updateFlags(RequestLogProperty.REQUEST_CONTENT);
        int requestCompletionFlags = RequestLogProperty.FLAGS_REQUEST_COMPLETE & ~this.deferredFlags;
        if (this.isAvailable(requestCompletionFlags)) {
            this.setNamesIfAbsent();
        }
    }

    @Override
    public Object rawRequestContent() {
        this.ensureAvailable(RequestLogProperty.REQUEST_CONTENT);
        return this.rawRequestContent;
    }

    @Override
    public String requestContentPreview() {
        this.ensureAvailable(RequestLogProperty.REQUEST_CONTENT_PREVIEW);
        return this.requestContentPreview;
    }

    @Override
    public void requestContentPreview(@Nullable String requestContentPreview) {
        if (this.isAvailable(RequestLogProperty.REQUEST_CONTENT_PREVIEW)) {
            return;
        }
        this.requestContentPreview = requestContentPreview;
        this.updateFlags(RequestLogProperty.REQUEST_CONTENT_PREVIEW);
    }

    @Override
    public HttpHeaders requestTrailers() {
        this.ensureAvailable(RequestLogProperty.REQUEST_TRAILERS);
        return this.requestTrailers;
    }

    @Override
    public void requestTrailers(HttpHeaders requestTrailers) {
        if (this.isAvailable(RequestLogProperty.REQUEST_TRAILERS)) {
            return;
        }
        Objects.requireNonNull(requestTrailers, "requestTrailers");
        this.requestTrailers = requestTrailers;
        this.updateFlags(RequestLogProperty.REQUEST_TRAILERS);
    }

    @Override
    public void endRequest() {
        this.endRequest0(null);
    }

    @Override
    public void endRequest(Throwable requestCause) {
        this.endRequest0(Objects.requireNonNull(requestCause, "requestCause"));
    }

    @Override
    public void endRequest(long requestEndTimeNanos) {
        this.endRequest0(null, requestEndTimeNanos);
    }

    @Override
    public void endRequest(Throwable requestCause, long requestEndTimeNanos) {
        this.endRequest0(Objects.requireNonNull(requestCause, "requestCause"), requestEndTimeNanos);
    }

    private void endRequest0(@Nullable Throwable requestCause) {
        this.endRequest0(requestCause, System.nanoTime());
    }

    private void endRequest0(@Nullable Throwable requestCause, long requestEndTimeNanos) {
        int deferredFlags = requestCause != null ? this.deferredFlags & ~(RequestLogProperty.REQUEST_CONTENT.flag() | RequestLogProperty.REQUEST_CONTENT_PREVIEW.flag()) : this.deferredFlags;
        int flags = RequestLogProperty.FLAGS_REQUEST_COMPLETE & ~deferredFlags;
        if (this.isAvailable(flags)) {
            return;
        }
        this.startRequest(requestEndTimeNanos, SystemInfo.currentTimeMicros());
        this.session(null, this.context().sessionProtocol(), null, null);
        assert (this.sessionProtocol != null);
        if (this.scheme == null) {
            this.scheme = Scheme.of(this.serializationFormat, this.sessionProtocol);
        }
        if (this.requestHeaders == null) {
            HttpRequest req = this.context().request();
            if (req != null) {
                this.requestHeaders = req.headers();
            } else {
                RequestHeaders requestHeaders = this.requestHeaders = this.sessionProtocol.isTls() ? DUMMY_REQUEST_HEADERS_HTTPS : DUMMY_REQUEST_HEADERS_HTTP;
            }
        }
        if (!DefaultRequestLog.hasInterestedFlags(deferredFlags, RequestLogProperty.REQUEST_CONTENT) || this.isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
            this.setNamesIfAbsent();
        }
        this.requestEndTimeNanos = requestEndTimeNanos;
        if (requestCause instanceof HttpStatusException || requestCause instanceof HttpResponseException) {
            this.requestCause = requestCause.getCause();
        } else if (!(requestCause instanceof ResponseCompleteException)) {
            this.requestCause = requestCause;
        }
        this.updateFlags(flags);
    }

    private void setNamesIfAbsent() {
        if (this.name == null) {
            RpcRequest rpcReq;
            String newServiceName = null;
            String newName = null;
            ServiceConfig config = null;
            ServiceRequestContext sctx = null;
            if (this.ctx instanceof ServiceRequestContext) {
                sctx = (ServiceRequestContext)this.ctx;
                config = sctx.config();
                newServiceName = config.defaultServiceNaming().serviceName(sctx);
                newName = config.defaultLogName();
            }
            if ((rpcReq = this.ctx.rpcRequest()) == null && this.requestContent instanceof RpcRequest) {
                rpcReq = (RpcRequest)this.requestContent;
            }
            if (newServiceName == null) {
                if (config != null) {
                    newServiceName = ServiceNaming.fullTypeName().serviceName(sctx);
                } else if (rpcReq != null) {
                    newServiceName = rpcReq.serviceName();
                }
            }
            if (newName == null) {
                newName = rpcReq != null ? rpcReq.method() : this.ctx.method().name();
            }
            this.serviceName = newServiceName;
            this.name = newName;
            this.updateFlags(RequestLogProperty.NAME);
        }
    }

    @Override
    public void startResponse() {
        this.startResponse(System.nanoTime(), SystemInfo.currentTimeMicros(), true);
    }

    @Override
    public void startResponse(long responseStartTimeNanos, long responseStartTimeMicros) {
        this.startResponse(responseStartTimeNanos, responseStartTimeMicros, true);
    }

    private void startResponse(long responseStartTimeNanos, long responseStartTimeMicros, boolean updateFlags) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_START_TIME)) {
            return;
        }
        this.responseStartTimeNanos = responseStartTimeNanos;
        this.responseStartTimeMicros = responseStartTimeMicros;
        if (updateFlags) {
            this.updateFlags(RequestLogProperty.RESPONSE_START_TIME);
        }
    }

    @Override
    public long responseStartTimeMicros() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_START_TIME);
        return this.responseStartTimeMicros;
    }

    @Override
    public long responseStartTimeMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.responseStartTimeMicros());
    }

    @Override
    public long responseStartTimeNanos() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_START_TIME);
        return this.responseStartTimeNanos;
    }

    @Override
    public Long responseFirstBytesTransferredTimeNanos() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME);
        return this.responseFirstBytesTransferredTimeNanosSet ? Long.valueOf(this.responseFirstBytesTransferredTimeNanos) : null;
    }

    @Override
    public long responseEndTimeNanos() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_END_TIME);
        return this.responseEndTimeNanos;
    }

    @Override
    public long responseDurationNanos() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_END_TIME);
        return this.responseEndTimeNanos - this.responseStartTimeNanos;
    }

    @Override
    public long totalDurationNanos() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_END_TIME);
        return this.responseEndTimeNanos - this.requestStartTimeNanos;
    }

    @Override
    public Throwable responseCause() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_CAUSE);
        return this.responseCause;
    }

    @Override
    public void responseCause(Throwable cause) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_CAUSE)) {
            return;
        }
        Objects.requireNonNull(cause, "cause");
        this.setResponseCause(cause, true);
    }

    @Override
    public long responseLength() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_LENGTH);
        return this.responseLength;
    }

    @Override
    public void responseLength(long responseLength) {
        if (responseLength < 0L) {
            throw new IllegalArgumentException("responseLength: " + responseLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogProperty.RESPONSE_LENGTH)) {
            return;
        }
        this.responseLength = responseLength;
    }

    @Override
    public void responseFirstBytesTransferred() {
        if (this.isAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME)) {
            return;
        }
        this.responseFirstBytesTransferred0(System.nanoTime());
    }

    @Override
    public void responseFirstBytesTransferred(long responseFirstBytesTransferredTimeNanos) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME)) {
            return;
        }
        this.responseFirstBytesTransferred0(responseFirstBytesTransferredTimeNanos);
    }

    private void responseFirstBytesTransferred0(long responseFirstBytesTransferredTimeNanos) {
        this.responseFirstBytesTransferredTimeNanos = responseFirstBytesTransferredTimeNanos;
        this.responseFirstBytesTransferredTimeNanosSet = true;
        this.updateFlags(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME);
    }

    @Override
    public void increaseResponseLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogProperty.RESPONSE_LENGTH)) {
            return;
        }
        this.responseLength += deltaBytes;
    }

    @Override
    public void increaseResponseLength(HttpData data) {
        Objects.requireNonNull(data, "data");
        this.increaseResponseLength(data.length());
    }

    @Override
    public ResponseHeaders responseHeaders() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_HEADERS);
        assert (this.responseHeaders != null);
        return this.responseHeaders;
    }

    @Override
    public void responseHeaders(ResponseHeaders responseHeaders) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_HEADERS)) {
            return;
        }
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders");
        this.updateFlags(RequestLogProperty.RESPONSE_HEADERS);
    }

    @Override
    public Object responseContent() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_CONTENT);
        return this.responseContent;
    }

    @Override
    public void responseContent(@Nullable Object responseContent, @Nullable Object rawResponseContent) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_CONTENT)) {
            return;
        }
        if (responseContent instanceof RpcResponse) {
            RpcResponse rpcResponse = (RpcResponse)responseContent;
            if (!rpcResponse.isDone()) {
                throw new IllegalArgumentException("responseContent must be complete: " + responseContent);
            }
            if (rpcResponse.cause() != null) {
                this.setResponseCause(rpcResponse.cause(), true);
            }
        }
        this.responseContent = responseContent;
        this.rawResponseContent = rawResponseContent;
        this.updateFlags(RequestLogProperty.RESPONSE_CONTENT);
    }

    @Override
    public String responseContentPreview() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
        return this.responseContentPreview;
    }

    @Override
    public void responseContentPreview(@Nullable String responseContentPreview) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_CONTENT_PREVIEW)) {
            return;
        }
        this.responseContentPreview = responseContentPreview;
        this.updateFlags(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
    }

    @Override
    public Object rawResponseContent() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_CONTENT);
        return this.rawResponseContent;
    }

    @Override
    public HttpHeaders responseTrailers() {
        this.ensureAvailable(RequestLogProperty.RESPONSE_TRAILERS);
        return this.responseTrailers;
    }

    @Override
    public void responseTrailers(HttpHeaders responseTrailers) {
        if (this.isAvailable(RequestLogProperty.RESPONSE_TRAILERS)) {
            return;
        }
        Objects.requireNonNull(responseTrailers, "responseTrailers");
        this.responseTrailers = responseTrailers;
        this.updateFlags(RequestLogProperty.RESPONSE_TRAILERS);
    }

    @Override
    public void endResponse() {
        this.endResponse0(this.responseContent instanceof RpcResponse ? ((RpcResponse)this.responseContent).cause() : null);
    }

    @Override
    public void endResponse(Throwable responseCause) {
        this.endResponse0(Objects.requireNonNull(responseCause, "responseCause"));
    }

    @Override
    public void endResponse(long responseEndTimeNanos) {
        this.endResponse0(null, responseEndTimeNanos);
    }

    @Override
    public void endResponse(Throwable responseCause, long responseEndTimeNanos) {
        this.endResponse0(Objects.requireNonNull(responseCause, "responseCause"), responseEndTimeNanos);
    }

    private void endResponse0(@Nullable Throwable responseCause) {
        this.endResponse0(responseCause, System.nanoTime());
    }

    private void endResponse0(@Nullable Throwable responseCause, long responseEndTimeNanos) {
        int deferredFlags = responseCause != null ? this.deferredFlags & ~(RequestLogProperty.RESPONSE_CONTENT.flag() | RequestLogProperty.RESPONSE_CONTENT_PREVIEW.flag()) : this.deferredFlags;
        int flags = RequestLogProperty.FLAGS_RESPONSE_COMPLETE & ~deferredFlags;
        if (this.isAvailable(flags)) {
            return;
        }
        this.startResponse(responseEndTimeNanos, SystemInfo.currentTimeMicros(), false);
        this.responseEndTimeNanos = responseEndTimeNanos;
        if (this.responseHeaders == null) {
            this.responseHeaders = responseCause instanceof HttpStatusException ? ResponseHeaders.of(((HttpStatusException)responseCause).httpStatus()) : DUMMY_RESPONSE_HEADERS;
        }
        this.setResponseCause(responseCause, false);
        this.updateFlags(flags);
    }

    private void setResponseCause(@Nullable Throwable responseCause, boolean updateFlag) {
        if (this.responseCause != null) {
            return;
        }
        if (responseCause instanceof HttpStatusException || responseCause instanceof HttpResponseException) {
            responseCause = responseCause.getCause();
        }
        if (responseCause != null) {
            this.responseCause = responseCause;
            if (updateFlag) {
                this.updateFlags(RequestLogProperty.RESPONSE_CAUSE);
            }
        }
    }

    public String toString() {
        int numChildren;
        String req = this.toStringRequestOnly();
        String res = this.toStringResponseOnly();
        int n = numChildren = this.children != null ? this.children.size() : 0;
        if (numChildren == 0) {
            try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
                String string = DefaultRequestLog.toStringWithoutChildren(ttl.stringBuilder(), req, res).toString();
                return string;
            }
        }
        return this.toStringWithChildren(req, res, numChildren);
    }

    private String toStringWithChildren(String req, String res, int numChildren) {
        assert (this.children != null);
        StringBuilder buf = DefaultRequestLog.toStringWithoutChildren(new StringBuilder(1024), req, res);
        buf.append(System.lineSeparator()).append("Children:");
        for (int i = 0; i < numChildren; ++i) {
            buf.append(System.lineSeparator());
            buf.append('\t');
            buf.append(this.children.get(i));
        }
        return buf.toString();
    }

    private static StringBuilder toStringWithoutChildren(StringBuilder buf, String req, String res) {
        return buf.append('{').append(req).append(", ").append(res).append('}');
    }

    private final class CompleteRequestLog
    implements RequestLog {
        private CompleteRequestLog() {
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isRequestComplete() {
            return true;
        }

        @Override
        public boolean isAvailable(RequestLogProperty property) {
            Objects.requireNonNull(property, "property");
            return true;
        }

        @Override
        public boolean isAvailable(RequestLogProperty ... properties) {
            Objects.requireNonNull(properties, "properties");
            Preconditions.checkArgument(properties.length != 0, "properties is empty.");
            return true;
        }

        @Override
        public boolean isAvailable(Iterable<RequestLogProperty> properties) {
            Objects.requireNonNull(properties, "properties");
            Preconditions.checkArgument(!Iterables.isEmpty(properties), "properties is empty.");
            return true;
        }

        @Override
        @Nullable
        public RequestLog getIfAvailable(RequestLogProperty ... properties) {
            Objects.requireNonNull(properties, "properties");
            Preconditions.checkArgument(properties.length != 0, "properties is empty.");
            return this;
        }

        @Override
        @Nullable
        public RequestLog getIfAvailable(Iterable<RequestLogProperty> properties) {
            Objects.requireNonNull(properties, "properties");
            Preconditions.checkArgument(!Iterables.isEmpty(properties), "properties is empty.");
            return this;
        }

        @Override
        public RequestLog partial() {
            return this;
        }

        @Override
        public CompletableFuture<RequestLog> whenComplete() {
            if (DefaultRequestLog.this.completedFuture == null) {
                DefaultRequestLog.this.completedFuture = UnmodifiableFuture.completedFuture(this);
            }
            return DefaultRequestLog.this.completedFuture;
        }

        @Override
        public CompletableFuture<RequestOnlyLog> whenRequestComplete() {
            CompletableFuture<RequestOnlyLog> cast = this.whenComplete();
            return cast;
        }

        @Override
        public CompletableFuture<RequestLog> whenAvailable(RequestLogProperty property) {
            return this.whenComplete();
        }

        @Override
        public CompletableFuture<RequestLog> whenAvailable(RequestLogProperty ... properties) {
            return this.whenComplete();
        }

        @Override
        public CompletableFuture<RequestLog> whenAvailable(Iterable<RequestLogProperty> properties) {
            return this.whenComplete();
        }

        @Override
        public RequestLog ensureComplete() {
            return this;
        }

        @Override
        public RequestOnlyLog ensureRequestComplete() {
            return this;
        }

        @Override
        public RequestLog ensureAvailable(RequestLogProperty property) {
            return this;
        }

        @Override
        public RequestLog ensureAvailable(RequestLogProperty ... properties) {
            return this;
        }

        @Override
        public RequestLog ensureAvailable(Iterable<RequestLogProperty> properties) {
            return this;
        }

        @Override
        public int availabilityStamp() {
            return RequestLogProperty.FLAGS_ALL_COMPLETE;
        }

        @Override
        public RequestContext context() {
            return DefaultRequestLog.this.ctx;
        }

        @Override
        @Nullable
        public RequestLogAccess parent() {
            return DefaultRequestLog.this.parent();
        }

        @Override
        public List<RequestLogAccess> children() {
            return DefaultRequestLog.this.children();
        }

        @Override
        public long requestStartTimeMicros() {
            return DefaultRequestLog.this.requestStartTimeMicros;
        }

        @Override
        public long requestStartTimeMillis() {
            return TimeUnit.MICROSECONDS.toMillis(DefaultRequestLog.this.requestStartTimeMicros);
        }

        @Override
        public long requestStartTimeNanos() {
            return DefaultRequestLog.this.requestStartTimeNanos;
        }

        @Override
        public Long requestFirstBytesTransferredTimeNanos() {
            return DefaultRequestLog.this.requestFirstBytesTransferredTimeNanosSet ? Long.valueOf(DefaultRequestLog.this.requestFirstBytesTransferredTimeNanos) : null;
        }

        @Override
        public long requestEndTimeNanos() {
            return DefaultRequestLog.this.requestEndTimeNanos;
        }

        @Override
        public long requestLength() {
            return DefaultRequestLog.this.requestLength;
        }

        @Override
        @Nullable
        public Throwable requestCause() {
            return DefaultRequestLog.this.requestCause;
        }

        @Override
        @Nullable
        public Channel channel() {
            return DefaultRequestLog.this.channel;
        }

        @Override
        @Nullable
        public SSLSession sslSession() {
            return DefaultRequestLog.this.sslSession;
        }

        @Override
        public SessionProtocol sessionProtocol() {
            assert (DefaultRequestLog.this.sessionProtocol != null);
            return DefaultRequestLog.this.sessionProtocol;
        }

        @Override
        @Nullable
        public ClientConnectionTimings connectionTimings() {
            return DefaultRequestLog.this.connectionTimings;
        }

        @Override
        public SerializationFormat serializationFormat() {
            return DefaultRequestLog.this.serializationFormat;
        }

        @Override
        public Scheme scheme() {
            assert (DefaultRequestLog.this.scheme != null);
            return DefaultRequestLog.this.scheme;
        }

        @Override
        @Nullable
        public String serviceName() {
            return DefaultRequestLog.this.serviceName;
        }

        @Override
        public String name() {
            return DefaultRequestLog.this.name;
        }

        @Override
        public String fullName() {
            return DefaultRequestLog.this.fullName();
        }

        @Override
        public String authenticatedUser() {
            return DefaultRequestLog.this.authenticatedUser;
        }

        @Override
        public RequestHeaders requestHeaders() {
            assert (DefaultRequestLog.this.requestHeaders != null);
            return DefaultRequestLog.this.requestHeaders;
        }

        @Override
        @Nullable
        public Object requestContent() {
            return DefaultRequestLog.this.requestContent;
        }

        @Override
        @Nullable
        public Object rawRequestContent() {
            return DefaultRequestLog.this.rawRequestContent;
        }

        @Override
        @Nullable
        public String requestContentPreview() {
            return DefaultRequestLog.this.requestContentPreview;
        }

        @Override
        public HttpHeaders requestTrailers() {
            return DefaultRequestLog.this.requestTrailers;
        }

        @Override
        public long responseStartTimeMicros() {
            return DefaultRequestLog.this.responseStartTimeMicros;
        }

        @Override
        public long responseStartTimeMillis() {
            return TimeUnit.MICROSECONDS.toMillis(DefaultRequestLog.this.responseStartTimeMicros);
        }

        @Override
        public long responseStartTimeNanos() {
            return DefaultRequestLog.this.responseStartTimeNanos;
        }

        @Override
        public Long responseFirstBytesTransferredTimeNanos() {
            return DefaultRequestLog.this.responseFirstBytesTransferredTimeNanosSet ? Long.valueOf(DefaultRequestLog.this.responseFirstBytesTransferredTimeNanos) : null;
        }

        @Override
        public long responseEndTimeNanos() {
            return DefaultRequestLog.this.responseEndTimeNanos;
        }

        @Override
        public long responseLength() {
            return DefaultRequestLog.this.responseLength;
        }

        @Override
        @Nullable
        public Throwable responseCause() {
            return DefaultRequestLog.this.responseCause;
        }

        @Override
        public ResponseHeaders responseHeaders() {
            assert (DefaultRequestLog.this.responseHeaders != null);
            return DefaultRequestLog.this.responseHeaders;
        }

        @Override
        @Nullable
        public Object responseContent() {
            return DefaultRequestLog.this.responseContent;
        }

        @Override
        @Nullable
        public Object rawResponseContent() {
            return DefaultRequestLog.this.rawResponseContent;
        }

        @Override
        @Nullable
        public String responseContentPreview() {
            return DefaultRequestLog.this.responseContentPreview;
        }

        @Override
        public HttpHeaders responseTrailers() {
            return DefaultRequestLog.this.responseTrailers;
        }

        public String toString() {
            return DefaultRequestLog.this.toString();
        }
    }

    private static final class RequestLogFuture
    extends EventLoopCheckingFuture<RequestLog> {
        final int interestedFlags;

        RequestLogFuture(int interestedFlags) {
            this.interestedFlags = interestedFlags;
        }

        void completeLog(RequestLog log) {
            super.complete(log);
        }

        @Override
        public boolean complete(RequestLog value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public void obtrudeValue(RequestLog value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeException(Throwable ex) {
            throw new UnsupportedOperationException();
        }
    }
}

